/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.translations.googletranslate;

import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.translations.ITranslationService;
import org.fao.geonet.translations.googletranslate.GoogleTranslateClient;
import org.fao.geonet.translations.googletranslate.GoogleTranslateClientException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GoogleTranslateService
implements ITranslationService {
    private SettingManager settingManager;

    @Autowired
    public GoogleTranslateService(SettingManager settingManager) {
        this.settingManager = settingManager;
    }

    @Override
    public String name() {
        return "GoogleTranslate";
    }

    @Override
    public String translate(String text, String fromLanguage, String toLanguage) {
        try {
            GoogleTranslateClient translateClient = new GoogleTranslateClient(this.settingManager.getValue("system/translation/serviceUrl"), this.settingManager.getValue("system/translation/apiKey"));
            return translateClient.translate(text, fromLanguage, toLanguage);
        }
        catch (GoogleTranslateClientException ex) {
            return text;
        }
    }
}

