/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.monitor.health;

import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import com.yammer.metrics.core.HealthCheck;
import java.io.IOException;
import jeeves.monitor.HealthCheckFactory;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.kernel.search.EsSearchManager;
import org.springframework.context.ConfigurableApplicationContext;

public class IndexReadOnlyHealthCheck
implements HealthCheckFactory {
    public HealthCheck create(ServiceContext context) {
        return new HealthCheck(this.getClass().getSimpleName()){

            protected HealthCheck.Result check() {
                try {
                    ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
                    EsSearchManager esSearchManager = (EsSearchManager)applicationContext.getBean(EsSearchManager.class);
                    String indexName = esSearchManager.getDefaultIndex();
                    boolean isReadOnly = esSearchManager.isIndexWritable(indexName);
                    if (!isReadOnly) {
                        return HealthCheck.Result.healthy((String)String.format("Index '%s' is writable.", indexName));
                    }
                    return HealthCheck.Result.unhealthy((String)"Index is in Readonly mode. Check disk usage and/or indexing server logs.");
                }
                catch (ElasticsearchException | IOException e) {
                    return HealthCheck.Result.unhealthy((Throwable)e);
                }
            }
        };
    }
}

