/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.UriMapper;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteRetriever;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRetriever;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavParams;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavRetriever;
import org.fao.geonet.kernel.search.IndexingMode;
import org.fao.geonet.repository.MetadataRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.jdom.JDOMException;

class Harvester
extends BaseAligner<WebDavParams>
implements IHarvester<HarvestResult> {
    private Logger log;
    private ServiceContext context;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private MetadataRepository metadataRepository;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UriMapper localUris;
    private HarvestResult result;
    private SchemaManager schemaMan;
    private List<HarvestError> errors;
    private String processName;
    private Map<String, Object> processParams = new HashMap<String, Object>();

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, WebDavParams params, List<HarvestError> errors) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
        this.result = new HarvestResult();
        this.result.addedMetadata = 0;
        this.result.uuidSkipped = 0;
        this.result.datasetUuidExist = 0;
        this.result.couldNotInsert = 0;
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        this.metadataRepository = (MetadataRepository)gc.getBean(MetadataRepository.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        RemoteRetriever rr;
        this.log = log;
        if (log.isDebugEnabled()) {
            log.debug("Retrieving remote metadata information for : " + ((WebDavParams)this.params).getName());
        }
        if (((WebDavParams)this.params).subtype.equals("webdav")) {
            rr = new WebDavRetriever();
        } else if (((WebDavParams)this.params).subtype.equals("waf")) {
            rr = new WAFRetriever();
        } else {
            throw new IllegalArgumentException(((WebDavParams)this.params).subtype + " is not one of webdav or waf");
        }
        try {
            Log.info((String)"jeeves.service", (Object)("webdav harvest subtype : " + ((WebDavParams)this.params).subtype));
            rr.init(this.cancelMonitor, log, this.context, (WebDavParams)this.params);
            List<RemoteFile> files = rr.retrieve();
            log.info("Number of remote files found : " + files.size());
            this.align(files);
        }
        finally {
            rr.destroy();
        }
        return this.result;
    }

    private void align(List<RemoteFile> files) throws Exception {
        this.log.info("Start of alignment for : " + ((WebDavParams)this.params).getName());
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUris = new UriMapper(this.context, ((WebDavParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((WebDavParams)this.params).xslfilter);
        this.processName = (String)filter.one();
        this.processParams = (Map)filter.two();
        for (String uri : this.localUris.getUris()) {
            if (this.cancelMonitor.get()) {
                return;
            }
            if (this.exists(files, uri)) continue;
            String id = this.localUris.getRecords((String)uri).get((int)0).id;
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Removing old metadata with local id:" + id);
            }
            try {
                this.metadataManager.deleteMetadataGroup(this.context, id);
            }
            catch (Exception e) {
                this.log.error("Error occurred while deleting metadata id");
            }
            this.metadataManager.flush();
            ++this.result.locallyRemoved;
        }
        for (RemoteFile rf : files) {
            if (this.cancelMonitor.get()) {
                return;
            }
            ++this.result.totalMetadata;
            List<RecordInfo> records = this.localUris.getRecords(rf.getPath());
            if (records == null) {
                this.addMetadata(rf);
                continue;
            }
            this.updateMetadata(rf, records.get(0), false);
        }
        this.log.info("End of alignment for : " + ((WebDavParams)this.params).getName());
    }

    private boolean exists(List<RemoteFile> files, String uri) {
        for (RemoteFile rf : files) {
            if (!uri.equals(rf.getPath())) continue;
            return true;
        }
        return false;
    }

    private void addMetadata(RemoteFile rf) throws Exception {
        ISODate date;
        String uuid;
        String schema;
        Element md;
        block20: {
            md = this.retrieveMetadata(rf);
            if (md == null) {
                return;
            }
            schema = this.dataMan.autodetectSchema(md);
            uuid = this.dataMan.extractUUID(schema, md);
            if (uuid == null) {
                String path = rf.getPath();
                int start = path.lastIndexOf("/") + 1;
                uuid = path.substring(start, path.length() - 4);
            }
            if (this.dataMan.existsMetadataUuid(uuid)) {
                ++this.result.datasetUuidExist;
                switch (((WebDavParams)this.params).getOverrideUuid()) {
                    case OVERRIDE: {
                        Metadata existingMetadata = this.metadataRepository.findOneByUuid(uuid);
                        RecordInfo existingRecordInfo = new RecordInfo((AbstractMetadata)existingMetadata);
                        this.updateMetadata(rf, existingRecordInfo, true);
                        this.log.info("Overriding record with uuid " + uuid);
                        ++this.result.updatedMetadata;
                        if (((WebDavParams)this.params).isIfRecordExistAppendPrivileges()) {
                            this.addPrivileges(this.dataMan.getMetadataId(uuid), ((WebDavParams)this.params).getPrivileges(), this.localGroups, this.context);
                            ++this.result.privilegesAppendedOnExistingRecord;
                        }
                        return;
                    }
                    case RANDOM: {
                        this.log.info("Generating random uuid for remote record with uuid " + uuid);
                        uuid = null;
                        break;
                    }
                    case SKIP: {
                        this.log.info("Skipping record with uuid " + uuid);
                        ++this.result.uuidSkipped;
                        return;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                this.log.debug("  - Setting uuid for metadata with remote path : " + rf.getPath());
                try {
                    md = this.dataMan.setUUID(schema, uuid, md);
                    ++this.result.addedMetadata;
                }
                catch (Exception e) {
                    this.log.error("  - Failed to set uuid for metadata with remote path : " + rf.getPath());
                    this.errors.add(new HarvestError(this.context, e));
                    ++this.result.couldNotInsert;
                    return;
                }
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Adding metadata with remote path : " + rf.getPath());
            }
            if (((WebDavParams)this.params).isTranslateContent()) {
                md = this.translateMetadataContent(this.context, md, schema);
            }
            if (StringUtils.isNotEmpty((String)((WebDavParams)this.params).xslfilter)) {
                md = HarvesterUtil.processMetadata(this.dataMan.getSchema(schema), md, this.processName, this.processParams);
                schema = this.dataMan.autodetectSchema(md);
            }
            date = null;
            try {
                date = new ISODate(this.dataMan.extractDateModified(schema, md));
            }
            catch (Exception ex) {
                this.log.error("WebDavHarvester - addMetadata - Can't get metadata modified date for metadata uuid= " + uuid + ", using current date for modified date");
                if (rf.getChangeDate() == null) break block20;
                date = rf.getChangeDate();
            }
        }
        if (date == null) {
            date = new ISODate();
        }
        Metadata metadata = new Metadata();
        metadata.setUuid(uuid);
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setChangeDate(date).setCreateDate(date).setType(MetadataType.METADATA);
        metadata.getSourceInfo().setSourceId(((WebDavParams)this.params).getUuid()).setOwner(Integer.valueOf(this.getOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((WebDavParams)this.params).getUuid()).setUri(rf.getPath());
        this.addCategories((AbstractMetadata)metadata, ((WebDavParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((WebDavParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, IndexingMode.none, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((WebDavParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataManager.flush();
        this.dataMan.indexMetadata(id, true);
        ++this.result.addedMetadata;
    }

    private Element retrieveMetadata(RemoteFile rf) {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Getting remote file : " + rf.getPath());
            }
            Element md = rf.getMetadata(this.schemaMan);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Record got:\n" + Xml.getString((Element)md));
            }
            this.dataMan.autodetectSchema(md);
            try {
                Integer groupIdVal = null;
                if (StringUtils.isNotEmpty((String)((WebDavParams)this.params).getOwnerIdGroup())) {
                    groupIdVal = this.getGroupOwner();
                }
                ((WebDavParams)this.params).getValidate().validate(this.dataMan, this.context, md, groupIdVal);
                return (Element)md.detach();
            }
            catch (Exception e) {
                this.log.info("Skipping metadata that does not validate. Path is : " + rf.getPath());
                ++this.result.doesNotValidate;
            }
        }
        catch (NoSchemaMatchesException e) {
            this.log.warning("Skipping metadata with unknown schema. Path is : " + rf.getPath());
            ++this.result.unknownSchema;
        }
        catch (JDOMException e) {
            this.log.warning("Skipping metadata with bad XML format. Path is : " + rf.getPath());
            ++this.result.badFormat;
        }
        catch (Exception e) {
            this.log.warning("Raised exception while getting metadata file : " + e);
            ++this.result.unretrievable;
        }
        return null;
    }

    private void updateMetadata(RemoteFile rf, RecordInfo recordInfo, boolean force) throws Exception {
        String uuid;
        Element md = null;
        String date = null;
        String schema = null;
        if (rf instanceof WAFRemoteFile) {
            block21: {
                md = this.retrieveMetadata(rf);
                if (md == null) {
                    return;
                }
                try {
                    schema = this.dataMan.autodetectSchema(md);
                    uuid = this.dataMan.extractUUID(schema, md);
                    if (!recordInfo.uuid.equals(uuid)) {
                        md = this.dataMan.setUUID(schema, recordInfo.uuid, md);
                    }
                }
                catch (Exception e) {
                    this.log.error("  - Failed to set uuid for metadata with remote path : " + rf.getPath());
                    return;
                }
                try {
                    date = this.dataMan.extractDateModified(schema, md);
                }
                catch (Exception ex) {
                    this.log.error("WebDavHarvester - updateMetadata - Can't get metadata modified date for metadata id= " + recordInfo.id + ", using current date for modified date");
                    if (rf.getChangeDate() == null) break block21;
                    date = rf.getChangeDate().getDateAndTime();
                }
            }
            ((WAFRemoteFile)rf).setChangeDate(date);
        }
        if (!force && !rf.isMoreRecentThan(recordInfo.changeDate)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Metadata XML not changed for path : " + rf.getPath());
            }
            ++this.result.unchangedMetadata;
        } else {
            block22: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Updating local metadata for path : " + rf.getPath());
                }
                if (!(rf instanceof WAFRemoteFile)) {
                    md = this.retrieveMetadata(rf);
                    if (md == null) {
                        return;
                    }
                    try {
                        schema = this.dataMan.autodetectSchema(md);
                        uuid = this.dataMan.extractUUID(schema, md);
                        if (!recordInfo.uuid.equals(uuid)) {
                            md = this.dataMan.setUUID(schema, recordInfo.uuid, md);
                        }
                    }
                    catch (Exception e) {
                        this.log.error("  - Failed to set uuid for metadata with remote path : " + rf.getPath());
                        return;
                    }
                    try {
                        date = this.dataMan.extractDateModified(schema, md);
                    }
                    catch (Exception ex) {
                        this.log.error("WebDavHarvester - updateMetadata - Can't get metadata modified date for metadata id= " + recordInfo.id + ", using current date for modified date");
                        if (rf.getChangeDate() == null) break block22;
                        date = rf.getChangeDate().getDateAndTime();
                    }
                }
            }
            if (((WebDavParams)this.params).isTranslateContent()) {
                md = this.translateMetadataContent(this.context, md, schema);
            }
            if (StringUtils.isNotEmpty((String)((WebDavParams)this.params).xslfilter)) {
                md = HarvesterUtil.processMetadata(this.dataMan.getSchema(schema), md, this.processName, this.processParams);
            }
            boolean validate = false;
            boolean ufo = false;
            String language = this.context.getLanguage();
            AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, recordInfo.id, md, validate, ufo, language, date, true, IndexingMode.none);
            if (force) {
                metadata.getHarvestInfo().setUuid(((WebDavParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((WebDavParams)this.params).getUuid());
                ((IMetadataManager)this.context.getBean(IMetadataManager.class)).save(metadata);
            }
            OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
            repository.deleteAllByMetadataId(Integer.parseInt(recordInfo.id));
            this.addPrivileges(recordInfo.id, ((WebDavParams)this.params).getPrivileges(), this.localGroups, this.context);
            metadata.getCategories().clear();
            this.addCategories(metadata, ((WebDavParams)this.params).getCategories(), this.localCateg, this.context, null, true);
            this.dataMan.flush();
            this.dataMan.indexMetadata(recordInfo.id, true);
        }
    }
}

