/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet.v20;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.v20.Search;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public class GeonetParams
extends AbstractParams {
    public String host;
    private ArrayList<Search> alSearches = new ArrayList();

    @Override
    public String getIcon() {
        return "gn20.gif";
    }

    public GeonetParams(DataManager dm) {
        super(dm);
    }

    @Override
    public void create(Element node) throws BadInputEx {
        super.create(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.host = Util.getParam((Element)site, (String)"host", (String)"");
        this.addSearches(searches);
    }

    @Override
    public void update(Element node) throws BadInputEx {
        super.update(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        this.host = Util.getParam((Element)site, (String)"host", (String)this.host);
        if (searches != null) {
            this.addSearches(searches);
        }
    }

    public Iterable<Search> getSearches() {
        return this.alSearches;
    }

    public String getServletPath() {
        if (StringUtils.isNotEmpty((String)this.host)) {
            try {
                return new URL(this.host).getPath();
            }
            catch (MalformedURLException ex) {
                Log.error((String)"geonetwork.harvest-man", (String)ex.getMessage(), (Throwable)ex);
            }
        }
        return "";
    }

    @Override
    public GeonetParams copy() {
        GeonetParams copy = new GeonetParams(this.dm);
        this.copyTo(copy);
        copy.host = this.host;
        for (Search s : this.alSearches) {
            copy.alSearches.add(s.copy());
        }
        return copy;
    }

    private void addSearches(Element searches) throws BadInputEx {
        this.alSearches.clear();
        if (searches == null) {
            return;
        }
        for (Object o : searches.getChildren("search")) {
            Element search = (Element)o;
            Search s = new Search();
            s.freeText = Util.getParam((Element)search, (String)"freeText", (String)"");
            s.title = Util.getParam((Element)search, (String)"title", (String)"");
            s.abstrac = Util.getParam((Element)search, (String)"abstract", (String)"");
            s.keywords = Util.getParam((Element)search, (String)"keywords", (String)"");
            s.digital = Util.getParam((Element)search, (String)"digital", (boolean)false);
            s.hardcopy = Util.getParam((Element)search, (String)"hardcopy", (boolean)false);
            s.siteId = Util.getParam((Element)search, (String)"siteId", (String)"");
            this.alSearches.add(s);
            if (!s.siteId.equals("")) continue;
            throw new BadParameterEx("siteId", (Object)"");
        }
    }
}

