/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.geonet;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractParams;
import org.fao.geonet.kernel.harvest.harvester.geonet.BaseSearch;
import org.fao.geonet.kernel.harvest.harvester.geonet.Group;
import org.fao.geonet.utils.Log;
import org.jdom.Element;

public abstract class BaseGeonetParams<S extends BaseSearch>
extends AbstractParams {
    public String host;
    public boolean createRemoteCategory;
    public boolean mefFormatFull;
    public String xslfilter;
    protected String node;
    protected Boolean useChangeDateForUpdate;
    protected ArrayList<S> alSearches = new ArrayList();
    protected ArrayList<Group> alCopyPolicy = new ArrayList();

    public BaseGeonetParams(DataManager dm) {
        super(dm);
    }

    @Override
    public void create(Element node) throws BadInputEx {
        super.create(node);
        Element site = node.getChild("site");
        Element policy = node.getChild("groupsCopyPolicy");
        Element searches = node.getChild("searches");
        this.host = Util.getParam((Element)site, (String)"host", (String)"");
        this.setNode(Util.getParam((Element)site, (String)"node", (String)"srv"));
        this.setUseChangeDateForUpdate(Util.getParam((Element)site, (String)"useChangeDateForUpdate", (boolean)false));
        this.createRemoteCategory = Util.getParam((Element)site, (String)"createRemoteCategory", (boolean)false);
        this.mefFormatFull = Util.getParam((Element)site, (String)"mefFormatFull", (boolean)false);
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        this.addSearches(searches);
        this.addCopyPolicy(policy);
    }

    @Override
    public void update(Element node) throws BadInputEx {
        super.update(node);
        Element site = node.getChild("site");
        Element searches = node.getChild("searches");
        Element policy = node.getChild("groupsCopyPolicy");
        this.host = Util.getParam((Element)site, (String)"host", (String)this.host);
        this.setNode(Util.getParam((Element)site, (String)"node", (String)this.getNode()));
        this.setUseChangeDateForUpdate(Util.getParam((Element)site, (String)"useChangeDateForUpdate", (boolean)false));
        this.createRemoteCategory = Util.getParam((Element)site, (String)"createRemoteCategory", (boolean)this.createRemoteCategory);
        this.mefFormatFull = Util.getParam((Element)site, (String)"mefFormatFull", (boolean)this.mefFormatFull);
        this.xslfilter = Util.getParam((Element)site, (String)"xslfilter", (String)"");
        if (searches != null) {
            this.addSearches(searches);
        }
        if (policy != null) {
            this.addCopyPolicy(policy);
        }
    }

    public Iterable<S> getSearches() {
        return this.alSearches;
    }

    public Iterable<Group> getGroupCopyPolicy() {
        return this.alCopyPolicy;
    }

    public String getServletPath() {
        if (StringUtils.isNotEmpty((String)this.host)) {
            try {
                return new URL(this.host).getPath();
            }
            catch (MalformedURLException ex) {
                Log.error((String)"geonetwork.harvest-man", (String)ex.getMessage(), (Throwable)ex);
            }
        }
        return "";
    }

    public boolean isSearchEmpty() {
        return this.alSearches.isEmpty();
    }

    @Override
    public abstract BaseGeonetParams<S> copy();

    public String getNode() {
        if (this.node == null) {
            this.setNode("srv");
        }
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public boolean useChangeDateForUpdate() {
        if (this.useChangeDateForUpdate == null) {
            this.setUseChangeDateForUpdate(false);
        }
        return this.useChangeDateForUpdate;
    }

    public void setUseChangeDateForUpdate(Boolean useChangeDateForUpdate) {
        if (useChangeDateForUpdate == null) {
            useChangeDateForUpdate = false;
        }
        this.useChangeDateForUpdate = useChangeDateForUpdate;
    }

    @Override
    public String getIcon() {
        return null;
    }

    protected abstract void addSearches(Element var1) throws BadInputEx;

    protected void addCopyPolicy(Element policy) throws BadInputEx {
        this.alCopyPolicy.clear();
        if (policy == null) {
            return;
        }
        for (Object o : policy.getChildren("group")) {
            Element group = (Element)o;
            this.alCopyPolicy.add(new Group(group));
        }
    }
}

