/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.harvest.harvester.AbstractHarvester;
import org.fao.geonet.kernel.harvest.harvester.HarvesterJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.springframework.context.ConfigurableApplicationContext;

public class HarversterJobListener
implements JobListener {
    private static final String HARVESTER_JOB_CONFIGURATION_LISTENER = "Harvester Job configuration listener";
    private static HarversterJobListener INSTANCE = new HarversterJobListener(){};
    private List<HarvestManager> listOfManager = new ArrayList<HarvestManager>();

    public static HarversterJobListener getInstance(HarvestManager manager) {
        HarversterJobListener.INSTANCE.listOfManager.add(manager);
        return INSTANCE;
    }

    public String getName() {
        return HARVESTER_JOB_CONFIGURATION_LISTENER;
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        if (context.getJobInstance() instanceof HarvesterJob) {
            HarvesterJob harvesterJob = (HarvesterJob)context.getJobInstance();
            ConfigurableApplicationContext applicationContext = null;
            AbstractHarvester harvester = null;
            for (HarvestManager manager : this.listOfManager) {
                harvester = manager.getHarvester(harvesterJob.getHarvesterId());
                if (harvester == null) continue;
                applicationContext = manager.getApplicationContext();
                break;
            }
            harvesterJob.setHarvester(harvester);
            harvesterJob.setApplicationContext(applicationContext);
        }
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
    }
}

