/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.TypeUtils;

class BasicAttributeVisitor
extends SimpleTypeVisitor6<Boolean, Element> {
    private final Context context;

    public BasicAttributeVisitor(Context context) {
        this.context = context;
    }

    @Override
    public Boolean visitPrimitive(PrimitiveType t, Element element) {
        return Boolean.TRUE;
    }

    @Override
    public Boolean visitArray(ArrayType t, Element element) {
        TypeMirror componentMirror = t.getComponentType();
        TypeElement componentElement = (TypeElement)this.context.getTypeUtils().asElement(componentMirror);
        return Constants.BASIC_ARRAY_TYPES.contains(componentElement.getQualifiedName().toString());
    }

    @Override
    public Boolean visitDeclared(DeclaredType declaredType, Element element) {
        if (ElementKind.ENUM.equals((Object)element.getKind())) {
            return Boolean.TRUE;
        }
        if (ElementKind.CLASS.equals((Object)element.getKind()) || ElementKind.INTERFACE.equals((Object)element.getKind())) {
            TypeElement typeElement = (TypeElement)element;
            String typeName = typeElement.getQualifiedName().toString();
            if (Constants.BASIC_TYPES.contains(typeName)) {
                return Boolean.TRUE;
            }
            if (TypeUtils.containsAnnotation(element, "javax.persistence.Embeddable")) {
                return Boolean.TRUE;
            }
            for (TypeMirror typeMirror : typeElement.getInterfaces()) {
                TypeElement interfaceElement = (TypeElement)this.context.getTypeUtils().asElement(typeMirror);
                if (!"java.io.Serializable".equals(interfaceElement.getQualifiedName().toString())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }
}

