/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;

class SimpleFeatureCollectionBridge
implements SimpleFeatureCollection {
    private FeatureCollection<SimpleFeatureType, SimpleFeature> collection;

    public SimpleFeatureCollectionBridge(FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) {
        if (featureCollection == null) {
            throw new NullPointerException("FeatureCollection required");
        }
        if (featureCollection instanceof SimpleFeatureCollection) {
            throw new IllegalArgumentException("Already a SimpleFeatureCollection");
        }
        this.collection = featureCollection;
    }

    @Override
    public SimpleFeatureIterator features() {
        final FeatureIterator<SimpleFeature> features = this.collection.features();
        return new SimpleFeatureIterator(){

            @Override
            public SimpleFeature next() throws NoSuchElementException {
                return (SimpleFeature)features.next();
            }

            @Override
            public boolean hasNext() {
                return features.hasNext();
            }

            @Override
            public void close() {
                features.close();
            }
        };
    }

    @Override
    public SimpleFeatureCollection sort(SortBy order) {
        return new SimpleFeatureCollectionBridge(this.collection.sort(order));
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        return new SimpleFeatureCollectionBridge(this.collection.subCollection(filter));
    }

    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        this.collection.accepts(visitor, progress);
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> o) {
        return this.collection.containsAll(o);
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.collection.getBounds();
    }

    @Override
    public String getID() {
        return this.collection.getID();
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.collection.getSchema();
    }

    @Override
    public boolean isEmpty() {
        return this.collection.isEmpty();
    }

    @Override
    public int size() {
        return this.collection.size();
    }

    @Override
    public Object[] toArray() {
        return this.collection.toArray();
    }

    @Override
    public <O> O[] toArray(O[] a) {
        return this.collection.toArray(a);
    }
}

