/*
 * Decompiled with CFR 0.152.
 */
package lizard.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class MotorolaIntelInputFilter {
    private RandomAccessFile raf;
    private boolean isIntel;

    public MotorolaIntelInputFilter(RandomAccessFile raf, boolean isIntel) {
        this.raf = raf;
        this.isIntel = isIntel;
    }

    public boolean isIntel() {
        return this.isIntel;
    }

    public short readByte() throws IOException {
        short b = (short)this.raf.readUnsignedByte();
        return b;
    }

    public void writeByte(int v) throws IOException {
        this.raf.writeByte(v);
    }

    public int readShort() throws IOException {
        int s = 0;
        if (this.isIntel) {
            int l = 0;
            int h = 0;
            l = this.raf.readUnsignedByte();
            h = this.raf.readUnsignedByte();
            s = ((h & 0xFFFF) << 8) + (l & 0xFFFF);
        } else {
            s = this.raf.readUnsignedShort();
        }
        return s;
    }

    public int readUnsignedShort() throws IOException {
        int s = 0;
        if (this.isIntel) {
            int l = 0;
            int h = 0;
            l = this.raf.readUnsignedByte();
            h = this.raf.readUnsignedByte();
            s = ((h & 0xFFFF) << 8) + (l & 0xFFFF);
        } else {
            s = this.raf.readUnsignedShort();
        }
        return s;
    }

    public void writeShort(int v) throws IOException {
        if (this.isIntel) {
            int b1 = 0;
            int b2 = 0;
            b1 = (v & 0xFF00) >> 8;
            b2 = v & 0xFF;
            v = ((b2 & 0xFF) << 8) + (b1 & 0xFF);
        }
        this.raf.writeShort(v);
    }

    public long readInt() throws IOException {
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        int b4 = 0;
        long i = this.raf.readInt();
        if (this.isIntel) {
            b1 = (int)((i & 0xFFFFFFFFFF000000L) >> 24);
            b2 = (int)((i & 0xFF0000L) >> 16);
            b3 = (int)((i & 0xFF00L) >> 8);
            b4 = (int)(i & 0xFFL);
            i = ((b4 & 0xFF) << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF);
        }
        return i;
    }

    public void writeInt(int v) throws IOException {
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        int b4 = 0;
        if (this.isIntel) {
            b1 = (v & 0xFF000000) >> 24;
            b2 = (v & 0xFF0000) >> 16;
            b3 = (v & 0xFF00) >> 8;
            b4 = v & 0xFF;
            v = ((b4 & 0xFF) << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF);
        }
        this.raf.writeInt(v);
    }

    public void readFully(byte[] b) throws IOException {
        this.raf.readFully(b, 0, b.length);
    }

    public void write(byte[] b) throws IOException {
        this.raf.write(b);
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        int n = 0;
        while (n < len) {
            int count = this.raf.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.raf.write(b, off, len);
    }

    public void readProperly(byte[] bytes, int typeSize, int len) throws IOException {
        if (!this.isIntel || typeSize < 2) {
            this.readFully(bytes, 0, len);
        } else {
            int n = 0;
            int b1 = 0;
            int b2 = 0;
            int b3 = 0;
            int b4 = 0;
            int b5 = 0;
            int b6 = 0;
            int b7 = 0;
            int b8 = 0;
            while (n < len) {
                switch (typeSize) {
                    case 2: {
                        b1 = this.raf.readUnsignedByte();
                        b2 = this.raf.readUnsignedByte();
                        bytes[n] = (byte)b2;
                        bytes[n + 1] = (byte)b1;
                        break;
                    }
                    case 4: {
                        b1 = this.raf.readUnsignedByte();
                        b2 = this.raf.readUnsignedByte();
                        b3 = this.raf.readUnsignedByte();
                        b4 = this.raf.readUnsignedByte();
                        bytes[n] = (byte)b4;
                        bytes[n + 1] = (byte)b3;
                        bytes[n + 2] = (byte)b2;
                        bytes[n + 3] = (byte)b1;
                        break;
                    }
                    case 8: {
                        b1 = this.raf.readUnsignedByte();
                        b2 = this.raf.readUnsignedByte();
                        b3 = this.raf.readUnsignedByte();
                        b4 = this.raf.readUnsignedByte();
                        b5 = this.raf.readUnsignedByte();
                        b6 = this.raf.readUnsignedByte();
                        b7 = this.raf.readUnsignedByte();
                        b8 = this.raf.readUnsignedByte();
                        bytes[n] = (byte)b8;
                        bytes[n + 1] = (byte)b7;
                        bytes[n + 2] = (byte)b6;
                        bytes[n + 3] = (byte)b5;
                        bytes[n + 4] = (byte)b4;
                        bytes[n + 5] = (byte)b3;
                        bytes[n + 6] = (byte)b2;
                        bytes[n + 7] = (byte)b1;
                        break;
                    }
                }
                n += typeSize;
            }
        }
    }

    public void writeProperly(byte[] bytes, int typeSize, int len) throws IOException {
        if (!this.isIntel || typeSize < 2) {
            this.write(bytes, 0, len);
        } else {
            int n = 0;
            byte b1 = 0;
            byte b2 = 0;
            byte b3 = 0;
            byte b4 = 0;
            byte b5 = 0;
            byte b6 = 0;
            byte b7 = 0;
            byte b8 = 0;
            while (n < len) {
                switch (typeSize) {
                    case 2: {
                        b2 = bytes[n];
                        b1 = bytes[n + 1];
                        int v = ((b2 & 0xFF) << 8) + (b1 & 0xFF);
                        this.raf.writeShort(v);
                        break;
                    }
                    case 4: {
                        b4 = bytes[n];
                        b3 = bytes[n + 1];
                        b2 = bytes[n + 2];
                        b1 = bytes[n + 3];
                        int v = ((b4 & 0xFF) << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF);
                        this.raf.writeInt(v);
                        break;
                    }
                    case 8: {
                        b8 = bytes[n];
                        b7 = bytes[n + 1];
                        b6 = bytes[n + 2];
                        b5 = bytes[n + 3];
                        b4 = bytes[n + 4];
                        b3 = bytes[n + 5];
                        b2 = bytes[n + 6];
                        b1 = bytes[n + 7];
                        long lv = ((b8 & 0xFF) << 56) + ((b7 & 0xFF) << 48) + ((b6 & 0xFF) << 40) + ((b5 & 0xFF) << 32) + ((b4 & 0xFF) << 24) + ((b3 & 0xFF) << 16) + ((b2 & 0xFF) << 8) + (b1 & 0xFF);
                        this.raf.writeLong(lv);
                        break;
                    }
                }
                n += typeSize;
            }
        }
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public long length() throws IOException {
        return this.raf.length();
    }

    public void close() throws IOException {
        this.raf.close();
    }
}

