/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class ScaleNearestOpImage
extends ScaleOpImage {
    protected InterpolationNearest interpN = null;
    protected byte[][] byteLookupTable;

    public ScaleNearestOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        int i;
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        int numBands = this.getSampleModel().getNumBands();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        Range nod = nodata;
        double[] destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues;
        }
        if (interp instanceof InterpolationNearest) {
            this.interpN = (InterpolationNearest)interp;
            this.interp = this.interpN;
            this.interpN.setROIBounds(this.roiBounds);
            if (nod == null) {
                nod = this.interpN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = new double[]{this.interpN.getDestinationNoData()};
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues;
        }
        if (this.destinationNoDataDouble != null && this.destinationNoDataDouble.length < numBands) {
            double[] tmp = new double[numBands];
            Arrays.fill(tmp, this.destinationNoDataDouble[0]);
            this.destinationNoDataDouble = tmp;
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        this.destinationNoDataByte = new byte[numBands];
        this.destinationNoDataShort = new short[numBands];
        this.destinationNoDataUShort = new short[numBands];
        this.destinationNoDataInt = new int[numBands];
        this.destinationNoDataFloat = new float[numBands];
        for (i = 0; i < numBands; ++i) {
            this.destinationNoDataByte[i] = (byte)((int)this.destinationNoDataDouble[i] & 0xFF);
            this.destinationNoDataUShort[i] = (short)((short)this.destinationNoDataDouble[i] & 0xFFFF);
            this.destinationNoDataShort[i] = (short)this.destinationNoDataDouble[i];
            this.destinationNoDataInt[i] = (int)this.destinationNoDataDouble[i];
            this.destinationNoDataFloat[i] = (float)this.destinationNoDataDouble[i];
        }
        if (this.hasNoData) {
            this.byteLookupTable = new byte[numBands][256];
            for (i = 0; i < this.byteLookupTable[0].length; ++i) {
                byte value = (byte)i;
                for (int b = 0; b < numBands; ++b) {
                    this.byteLookupTable[b][i] = this.noData.contains(value) ? this.destinationNoDataByte[b] : value;
                }
            }
        }
        if (this.hasNoData && this.destinationNoDataDouble != null) {
            this.setProperty("GC_NODATA", new NoDataContainer(this.destinationNoDataDouble));
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useRoiAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
                roiScanlineStride = roiAccessor.getScanlineStride();
                yposRoi = new int[dheight];
            } else {
                roiIter = RandomIterFactory.create((RenderedImage)this.srcROIImgExt, (Rectangle)this.roiRect, (boolean)true, (boolean)true);
            }
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        this.dataType = dest.getSampleModel().getDataType();
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, srcRect, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi, roiIter);
            }
        }
        if (dstAccessor.isDataCopy()) {
            if (dstAccessor.needsClamping()) {
                dstAccessor.clampDataArrays();
            }
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle srcRect, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte[k] : srcData[pos]) : this.destinationNoDataByte[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        dstData[dstPixelOffset] = this.byteLookupTable[k][value & 0xFF];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        if (this.byteLookupTable[k][value & 0xFF] == this.destinationNoDataByte[k]) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte[k] : this.byteLookupTable[k][value & 0xFF];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        dstData[dstPixelOffset] = this.byteLookupTable[k][value & 0xFF] == this.destinationNoDataByte[k] ? this.destinationNoDataByte[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte[k] : this.byteLookupTable[k][value & 0xFF]) : this.destinationNoDataByte[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFFFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0) & 0xFFFF) == 0 ? this.destinationNoDataUShort[k] : srcData[pos]) : this.destinationNoDataUShort[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataUShort[k] : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFFFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort[k] : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataUShort[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0) & 0xFFFF) == 0 ? this.destinationNoDataUShort[k] : value) : this.destinationNoDataUShort[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataShort[k] : srcData[pos]) : this.destinationNoDataShort[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort[k] : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort[k] : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataShort[k] : value) : this.destinationNoDataShort[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstData = null;
        int[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataInt[k] : srcData[pos]) : this.destinationNoDataInt[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt[k] : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt[k] : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataInt[k] : value) : this.destinationNoDataInt[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        float[] dstData = null;
        float[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataFloat[k] : srcData[pos]) : this.destinationNoDataFloat[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat[k] : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat[k] : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataFloat[k] : value) : this.destinationNoDataFloat[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi, RandomIter roiIter) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[] dstData = null;
        double[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble[k] : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataDouble[k] : srcData[pos]) : this.destinationNoDataDouble[k];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble[k] : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble[k];
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble[k] : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble[k] : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataDouble[k] : value) : this.destinationNoDataDouble[k]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }
}

