/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.xml.XMLSAXHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentFactory {
    public static final String VALIDATION_HINT = "DocumentFactory_VALIDATION_HINT";
    public static final String DISABLE_EXTERNAL_ENTITIES = "DocumentFactory_DISABLE_EXTERNAL_ENTITIES";

    public static Object getInstance(URI desiredDocument, Map<String, Object> hints) throws SAXException {
        return DocumentFactory.getInstance(desiredDocument, hints, Level.WARNING);
    }

    public static Object getInstance(URI desiredDocument, Map<String, Object> hints, Level level) throws SAXException {
        SAXParser parser = DocumentFactory.getParser(hints);
        XMLSAXHandler xmlContentHandler = new XMLSAXHandler(desiredDocument, hints);
        XMLSAXHandler.setLogLevel(level);
        try {
            parser.parse(desiredDocument.toString(), (DefaultHandler)xmlContentHandler);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return xmlContentHandler.getDocument();
    }

    public static Object getInstance(InputStream is, Map<String, Object> hints, Level level) throws SAXException {
        SAXParser parser = DocumentFactory.getParser(hints);
        XMLSAXHandler xmlContentHandler = new XMLSAXHandler(hints);
        XMLSAXHandler.setLogLevel(level);
        try {
            parser.parse(is, (DefaultHandler)xmlContentHandler);
        }
        catch (IOException e) {
            XMLSAXHandler.logger.warning(e.toString());
            throw new SAXException(e);
        }
        return xmlContentHandler.getDocument();
    }

    private static SAXParser getParser(Map<String, Object> hints) throws SAXException {
        SAXParserFactory spf = null;
        spf = hints != null && hints.containsKey("javax.xml.parsers.SAXParserFactory") ? (SAXParserFactory)hints.get("javax.xml.parsers.SAXParserFactory") : SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setValidating(false);
        try {
            spf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            if (hints != null && hints.containsKey(DISABLE_EXTERNAL_ENTITIES) && Boolean.TRUE.equals(hints.get(DISABLE_EXTERNAL_ENTITIES))) {
                spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            SAXParser sp = spf.newSAXParser();
            return sp;
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }
}

