/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.BiConsumer;

public final class HTMLNamedEntitiesParser {
    private static final HTMLNamedEntitiesParser instance = new HTMLNamedEntitiesParser();
    private RootState rootLevel_ = new RootState();

    private HTMLNamedEntitiesParser() {
        try (InputStream stream = HTMLNamedEntitiesParser.class.getResourceAsStream("html_entities.properties");){
            Properties props = new Properties();
            props.load(stream);
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                String value = (String)v;
                if (key.trim().isEmpty()) {
                    return;
                }
                this.rootLevel_.add(key, value);
            }));
            this.rootLevel_.optimize();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initilaize the HTML entities from file");
        }
    }

    public static HTMLNamedEntitiesParser get() {
        return instance;
    }

    public State lookup(String entityName) {
        State lastResult = this.rootLevel_;
        State lastMatchingResult = null;
        for (int i = 0; i < entityName.length(); ++i) {
            State result = ((State)lastResult).lookup(entityName.charAt(i));
            if (result.endNode_) {
                return result;
            }
            if (result == lastResult) {
                return lastMatchingResult == null ? lastResult : lastMatchingResult;
            }
            if (result.isMatch_) {
                lastMatchingResult = result;
            }
            lastResult = result;
        }
        return lastMatchingResult == null ? lastResult : lastMatchingResult;
    }

    public State lookup(int character, State state) {
        return state != null ? state.lookup(character) : this.rootLevel_.lookup(character);
    }

    protected static class RootState
    extends State {
        private int offset_ = 0;

        protected RootState() {
        }

        @Override
        public State lookup(int character) {
            int pos = character - this.offset_;
            if (pos >= 0 && pos < this.nextState_.length) {
                State s = this.nextState_[pos];
                return s != null ? s : this;
            }
            return this;
        }

        protected void optimize() {
            if (this.offset_ > 0) {
                throw new RuntimeException("Optimiize was called twice");
            }
            this.offset_ = this.characters_[0];
            State[] newNextLevel = new State[this.characters_[this.characters_.length - 1] - this.offset_ + 1];
            for (int i = 0; i < this.characters_.length; ++i) {
                State level;
                int c = this.characters_[i];
                newNextLevel[c - this.offset_] = level = this.nextState_[i];
            }
            this.nextState_ = newNextLevel;
            this.characters_ = null;
        }
    }

    public static class State {
        private final int depth_;
        int[] characters_ = new int[0];
        State[] nextState_ = new State[0];
        public final String entityOrFragment_;
        public String resolvedValue_;
        public final int length_;
        public final boolean endsWithSemicolon_;
        public boolean isMatch_;
        public boolean endNode_;

        protected State() {
            this.entityOrFragment_ = "";
            this.length_ = 0;
            this.depth_ = 0;
            this.endsWithSemicolon_ = false;
            this.isMatch_ = false;
            this.resolvedValue_ = null;
            this.endNode_ = false;
        }

        protected State(int depth, String entityFragment, String resolvedValue) {
            if (depth == entityFragment.length()) {
                this.entityOrFragment_ = entityFragment;
                this.length_ = entityFragment.length();
                this.depth_ = entityFragment.length();
                this.endsWithSemicolon_ = entityFragment.endsWith(";");
                this.isMatch_ = true;
                this.resolvedValue_ = resolvedValue;
                this.endNode_ = entityFragment.endsWith(";");
            } else {
                String currentFragment;
                this.entityOrFragment_ = currentFragment = entityFragment.substring(0, depth);
                this.length_ = currentFragment.length();
                this.depth_ = depth;
                this.endsWithSemicolon_ = false;
                this.isMatch_ = false;
                this.resolvedValue_ = null;
                this.endNode_ = false;
            }
        }

        protected void updateNonSemicolonEntity(String entity, String resolvedValue) {
            if (entity.endsWith(";")) {
                return;
            }
            if (entity.length() == this.depth_) {
                if (!entity.equals(this.entityOrFragment_)) {
                    throw new RuntimeException("Illegal state reached");
                }
                this.endNode_ = false;
                this.isMatch_ = true;
                this.resolvedValue_ = resolvedValue;
            }
        }

        protected void add(String entity, String resolvedValue) {
            if (this.depth_ >= entity.length()) {
                return;
            }
            char c = entity.charAt(this.depth_);
            int pos = Arrays.binarySearch(this.characters_, (int)c);
            if (pos < 0) {
                this.nextState_ = Arrays.copyOf(this.nextState_, this.nextState_.length + 1);
                this.characters_ = Arrays.copyOf(this.characters_, this.characters_.length + 1);
                int newPos = -(pos + 1);
                if (newPos != this.characters_.length - 1) {
                    System.arraycopy(this.characters_, newPos, this.characters_, newPos + 1, this.characters_.length - newPos - 1);
                    System.arraycopy(this.nextState_, newPos, this.nextState_, newPos + 1, this.nextState_.length - newPos - 1);
                }
                State newLevel = new State(this.depth_ + 1, entity, resolvedValue);
                this.characters_[newPos] = c;
                this.nextState_[newPos] = newLevel;
                newLevel.add(entity, resolvedValue);
            } else {
                this.nextState_[pos].updateNonSemicolonEntity(entity, resolvedValue);
                this.nextState_[pos].add(entity, resolvedValue);
            }
        }

        protected State lookup(int character) {
            int length = this.characters_.length;
            for (int i = 0; i < length; ++i) {
                int c = this.characters_[i];
                if (c < character) continue;
                if (c == character) {
                    return this.nextState_[i];
                }
                return this;
            }
            return this;
        }
    }
}

