/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.geotools.util.ObjectCache;

final class WeakObjectCache<K, V>
implements ObjectCache<K, V> {
    private final Map<K, WeakReference<V>> cache;
    private final Map<K, ReentrantLock> locks;

    public WeakObjectCache() {
        this(50);
    }

    public WeakObjectCache(int initialSize) {
        this.cache = Collections.synchronizedMap(new HashMap(initialSize));
        this.locks = new HashMap<K, ReentrantLock>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.clear();
            this.cache.clear();
        }
    }

    public boolean containsKey(K key) {
        if (this.cache.containsKey(key)) {
            WeakReference<V> reference = this.cache.get(key);
            if (reference == null) {
                return false;
            }
            return reference.get() != null;
        }
        return false;
    }

    @Override
    public V get(K key) {
        WeakReference<V> reference = this.cache.get(key);
        if (reference == null) {
            return null;
        }
        Object value = reference.get();
        if (value == null) {
            this.cache.remove(key);
        }
        return (V)value;
    }

    @Override
    public V peek(K key) {
        WeakReference<V> reference = this.cache.get(key);
        if (reference == null) {
            return null;
        }
        return (V)reference.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLock(K key) {
        ReentrantLock lock;
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            lock = this.locks.get(key);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(key, lock);
            }
        }
        lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeUnLock(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(key);
            if (lock == null) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            if (lock.getHoldCount() == 0) {
                throw new IllegalMonitorStateException("Cannot unlock prior to locking");
            }
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean holdsLock(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            ReentrantLock lock = this.locks.get(key);
            if (lock != null) {
                return lock.getHoldCount() != 0;
            }
        }
        return false;
    }

    @Override
    public void put(K key, V object) {
        this.writeLock(key);
        WeakReference<V> reference = new WeakReference<V>(object);
        this.cache.put(key, reference);
        this.writeUnLock(key);
    }

    @Override
    public Set<K> getKeys() {
        return new HashSet<K>(this.cache.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(K key) {
        Map<K, ReentrantLock> map = this.locks;
        synchronized (map) {
            this.locks.remove(key);
            this.cache.remove(key);
        }
    }
}

