/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.authentication.HttpHeaderInspectingApiRequestMatcher;
import org.keycloak.adapters.springsecurity.authentication.KeycloakCookieBasedRedirect;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeycloakAuthenticationEntryPoint
implements AuthenticationEntryPoint {
    public static final String DEFAULT_LOGIN_URI = "/sso/login";
    private static final String DEFAULT_REALM = "Unknown";
    private static final RequestMatcher DEFAULT_API_REQUEST_MATCHER = new HttpHeaderInspectingApiRequestMatcher();
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthenticationEntryPoint.class);
    private final RequestMatcher apiRequestMatcher;
    private String loginUri = "/sso/login";
    private String realm = "Unknown";
    private AdapterDeploymentContext adapterDeploymentContext;

    public KeycloakAuthenticationEntryPoint(AdapterDeploymentContext adapterDeploymentContext) {
        this(adapterDeploymentContext, DEFAULT_API_REQUEST_MATCHER);
    }

    public KeycloakAuthenticationEntryPoint(AdapterDeploymentContext adapterDeploymentContext, RequestMatcher apiRequestMatcher) {
        Assert.notNull((Object)apiRequestMatcher, (String)"apiRequestMatcher required");
        Assert.notNull((Object)adapterDeploymentContext, (String)"adapterDeploymentContext required");
        this.adapterDeploymentContext = adapterDeploymentContext;
        this.apiRequestMatcher = apiRequestMatcher;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        SimpleHttpFacade facade = new SimpleHttpFacade(request, response);
        if (this.apiRequestMatcher.matches(request) || this.adapterDeploymentContext.resolveDeployment((HttpFacade)facade).isBearerOnly()) {
            this.commenceUnauthorizedResponse(request, response);
        } else {
            this.commenceLoginRedirect(request, response);
        }
    }

    protected void commenceLoginRedirect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (request.getSession(false) == null && KeycloakCookieBasedRedirect.getRedirectUrlFromCookie(request) == null) {
            response.addCookie(KeycloakCookieBasedRedirect.createCookieFromRedirectUrl(request.getRequestURI()));
        }
        String queryParameters = "";
        if (!StringUtils.isEmpty((Object)request.getQueryString())) {
            queryParameters = "?" + request.getQueryString();
        }
        String contextAwareLoginUri = request.getContextPath() + this.loginUri + queryParameters;
        log.debug("Redirecting to login URI {}", (Object)contextAwareLoginUri);
        response.sendRedirect(contextAwareLoginUri);
    }

    protected void commenceUnauthorizedResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.addHeader("WWW-Authenticate", String.format("Bearer realm=\"%s\"", this.realm));
        response.sendError(HttpStatus.UNAUTHORIZED.value(), HttpStatus.UNAUTHORIZED.getReasonPhrase());
    }

    public void setLoginUri(String loginUri) {
        Assert.notNull((Object)loginUri, (String)"loginUri cannot be null");
        this.loginUri = loginUri;
    }

    public void setRealm(String realm) {
        Assert.notNull((Object)realm, (String)"realm cannot be null");
        this.realm = realm;
    }
}

