/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.csw.common;

import java.util.Map;
import org.fao.geonet.csw.common.exceptions.InvalidParameterValueEx;
import org.fao.geonet.kernel.SchemaManager;

public enum OutputSchema {
    DEFAULT("csw");

    private String schema;

    private OutputSchema(String schema) {
        this.schema = schema;
    }

    public static String parse(String schema, SchemaManager schemaManager) throws InvalidParameterValueEx {
        if (schema == null) {
            return "csw";
        }
        if (schema.equals("Record")) {
            return "csw";
        }
        if (schema.equals("IsoRecord")) {
            return "gmd";
        }
        if (schema.equals("csw:Record")) {
            return "csw";
        }
        if (schema.equals("csw:IsoRecord")) {
            return "gmd";
        }
        if (schema.equals("own")) {
            return "own";
        }
        Map typenames = schemaManager.getOutputSchemas();
        for (Map.Entry entry : typenames.entrySet()) {
            String ns = (String)entry.getValue();
            if (!schema.equals(ns)) continue;
            return (String)entry.getKey();
        }
        throw new InvalidParameterValueEx("outputSchema", String.format("'%s' output schema is not valid. Supported values are %s", schema, schemaManager.getListOfOutputSchemaURI().toString()));
    }

    public String toString() {
        return this.schema;
    }
}

