/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Map;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.PassThroughOperation;
import org.geotools.referencing.operation.DefaultSingleOperation;
import org.geotools.referencing.operation.transform.PassThroughTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;

public class DefaultPassThroughOperation
extends DefaultSingleOperation
implements PassThroughOperation {
    private static final long serialVersionUID = 4308173919747248695L;
    protected final Operation operation;

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Operation operation, int firstAffectedOrdinate, int numTrailingOrdinates) {
        this(properties, sourceCRS, targetCRS, operation, PassThroughTransform.create(firstAffectedOrdinate, operation.getMathTransform(), numTrailingOrdinates));
    }

    public DefaultPassThroughOperation(Map<String, ?> properties, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, Operation operation, MathTransform transform) {
        super(properties, sourceCRS, targetCRS, transform);
        this.operation = operation;
        DefaultPassThroughOperation.ensureNonNull("operation", operation);
        DefaultPassThroughOperation.ensureValidDimension(operation.getSourceCRS(), transform.getSourceDimensions());
        DefaultPassThroughOperation.ensureValidDimension(operation.getTargetCRS(), transform.getTargetDimensions());
    }

    private static void ensureValidDimension(CoordinateReferenceSystem crs, int dim) {
        if (crs.getCoordinateSystem().getDimension() > dim) {
            throw new IllegalArgumentException();
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public int[] getModifiedCoordinates() {
        if (!(this.transform instanceof PassThroughTransform)) {
            throw new UnsupportedImplementationException(this.transform.getClass());
        }
        return ((PassThroughTransform)this.transform).getModifiedCoordinates();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        String name = super.formatWKT(formatter);
        try {
            int[] ordinates;
            for (int ordinate : ordinates = this.getModifiedCoordinates()) {
                formatter.append(ordinate);
            }
        }
        catch (UnsupportedOperationException exception) {
            formatter.setInvalidWKT(PassThroughOperation.class);
        }
        formatter.append((IdentifiedObject)this.operation);
        return name;
    }
}

