/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.InvalidParameterCardinalityException;
import org.geotools.api.parameter.InvalidParameterNameException;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.referencing.AbstractIdentifiedObject;

final class ParameterValueList
extends AbstractList<GeneralParameterValue>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = -7446077551686135264L;
    private final ParameterDescriptorGroup descriptor;
    private final List<GeneralParameterValue> values;

    public ParameterValueList(ParameterDescriptorGroup descriptor, List<GeneralParameterValue> values) {
        this.descriptor = descriptor;
        this.values = values;
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public GeneralParameterValue get(int i) {
        return this.values.get(i);
    }

    @Override
    public int indexOf(Object o) {
        return this.values.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.values.lastIndexOf(o);
    }

    @Override
    public boolean equals(Object o) {
        return this.values.equals(o);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String toString() {
        return this.values.toString();
    }

    @Override
    public boolean add(GeneralParameterValue parameter) {
        ++this.modCount;
        GeneralParameterDescriptor type = parameter.getDescriptor();
        List descriptors = this.descriptor.descriptors();
        String name = type.getName().getCode();
        if (!descriptors.contains(type)) {
            for (GeneralParameterDescriptor descriptor : descriptors) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)descriptor, name)) continue;
                throw new IllegalArgumentException(MessageFormat.format("Illegal descriptor for parameter \"{0}\".", name));
            }
            Object value = parameter instanceof ParameterValue ? ((ParameterValue)parameter).getValue() : "(group)";
            throw new InvalidParameterNameException(MessageFormat.format("Illegal argument: \"{0}={1}\".", name, value), name);
        }
        int max = type.getMaximumOccurs();
        if (max == 1) {
            int i = this.values.size();
            while (--i >= 0) {
                GeneralParameterValue oldValue = this.values.get(i);
                GeneralParameterDescriptor oldDescriptor = oldValue.getDescriptor();
                if (!type.equals(oldDescriptor)) continue;
                assert (AbstractIdentifiedObject.nameMatches((IdentifiedObject)oldDescriptor, name)) : parameter;
                boolean same = parameter.equals(oldValue);
                this.values.set(i, parameter);
                return !same;
            }
        } else {
            int count = 0;
            for (GeneralParameterValue value : this.values) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
                ++count;
            }
            if (count >= max) {
                throw new InvalidParameterCardinalityException(MessageFormat.format("Too many occurences of \"{0}\". There is already {1} of them.", name, count), name);
            }
        }
        this.values.add(parameter);
        return true;
    }

    @Override
    public GeneralParameterValue remove(int index) {
        return this.remove(this.values.get(index).getDescriptor(), index);
    }

    private GeneralParameterValue remove(GeneralParameterDescriptor type, int index) {
        GeneralParameterValue value2;
        ++this.modCount;
        int count = 0;
        String name = type.getName().getCode();
        for (GeneralParameterValue value2 : this.values) {
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value2.getDescriptor(), name)) continue;
            ++count;
        }
        int min = type.getMinimumOccurs();
        if (count <= min) {
            int max = type.getMaximumOccurs();
            throw new InvalidParameterCardinalityException(MessageFormat.format("Parameter \"{0}\" occurs {1} time, while the expected range of occurences was [{2}..{3}].", name, count - 1, min, max), name);
        }
        value2 = this.values.remove(index);
        assert (value2 != null && type.equals(value2.getDescriptor())) : value2;
        return value2;
    }
}

