/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.store;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import org.apache.jena.atlas.lib.tuple.TupleMap;
import org.apache.jena.dboe.DBOpEnvException;
import org.apache.jena.dboe.base.file.BinaryDataFile;
import org.apache.jena.dboe.base.file.BufferChannel;
import org.apache.jena.dboe.base.file.FileFactory;
import org.apache.jena.dboe.base.file.FileSet;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.dboe.base.record.RecordFactory;
import org.apache.jena.dboe.index.Index;
import org.apache.jena.dboe.index.RangeIndex;
import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.trans.bplustree.BPlusTree;
import org.apache.jena.dboe.trans.bplustree.BPlusTreeFactory;
import org.apache.jena.dboe.trans.data.TransBinaryDataFile;
import org.apache.jena.dboe.transaction.txn.ComponentId;
import org.apache.jena.dboe.transaction.txn.TransactionCoordinator;
import org.apache.jena.dboe.transaction.txn.TransactionListener;
import org.apache.jena.dboe.transaction.txn.TransactionalBase;
import org.apache.jena.dboe.transaction.txn.TransactionalComponent;
import org.apache.jena.dboe.transaction.txn.TransactionalSystem;
import org.apache.jena.dboe.transaction.txn.journal.Journal;
import org.apache.jena.sparql.engine.main.OpExecutorFactory;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.solver.OpExecutorTDB2;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.QuadTable;
import org.apache.jena.tdb2.store.StoragePrefixesTDB;
import org.apache.jena.tdb2.store.StorageTDB;
import org.apache.jena.tdb2.store.TripleTable;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetable.NodeTableCache;
import org.apache.jena.tdb2.store.nodetable.NodeTableInline;
import org.apache.jena.tdb2.store.nodetable.NodeTableTRDF;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTableConcrete;
import org.apache.jena.tdb2.store.tupletable.TupleIndex;
import org.apache.jena.tdb2.store.tupletable.TupleIndexRecord;
import org.apache.jena.tdb2.sys.ComponentIdMgr;
import org.apache.jena.tdb2.sys.SystemTDB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TDB2StorageBuilder {
    private static Logger log = LoggerFactory.getLogger(TDB2StorageBuilder.class);
    private static FileFilter fileFilterNewDB = pathname -> {
        String fn = pathname.getName();
        if (fn.equals(".") || fn.equals("..")) {
            return false;
        }
        if (pathname.isDirectory()) {
            return true;
        }
        if (fn.equals("tdb.cfg")) {
            return false;
        }
        return !fn.equals("tdb.lock");
    };
    private final Location location;
    private final StoreParams params;
    private final TransactionalSystem txnSystem;
    private final ComponentIdMgr componentIdMgr;
    private final Collection<TransactionalComponent> components = new ArrayList<TransactionalComponent>();
    private final Collection<TransactionListener> listeners = new ArrayList<TransactionListener>();

    public static DatasetGraphTDB build(Location location) {
        return TDB2StorageBuilder.build(location, null, null);
    }

    public static DatasetGraphTDB build(Location location, StoreParams params, ReorderTransformation reorderTransform) {
        if (params == null) {
            params = location.isMem() ? StoreParams.getDftMemStoreParams() : StoreParams.getDftStoreParams();
        }
        if (reorderTransform == null) {
            reorderTransform = SystemTDB.getDefaultReorderTransform();
        }
        TransactionCoordinator txnCoord = TDB2StorageBuilder.buildTransactionCoordinator(location);
        TransactionalBase txnSystem = new TransactionalBase(txnCoord);
        TDB2StorageBuilder builder = new TDB2StorageBuilder((TransactionalSystem)txnSystem, location, params, new ComponentIdMgr(UUID.randomUUID()));
        StorageTDB storage = builder.buildStorage();
        StoragePrefixes prefixes = builder.buildPrefixes();
        builder.components.forEach(arg_0 -> ((TransactionCoordinator)txnCoord).add(arg_0));
        builder.listeners.forEach(arg_0 -> ((TransactionCoordinator)txnCoord).addListener(arg_0));
        txnCoord.start();
        DatasetGraphTDB dsg = new DatasetGraphTDB(location, params, reorderTransform, storage, prefixes, (TransactionalSystem)txnSystem);
        QC.setFactory((Context)dsg.getContext(), (OpExecutorFactory)OpExecutorTDB2.OpExecFactoryTDB);
        return dsg;
    }

    private static TransactionCoordinator buildTransactionCoordinator(Location location) {
        Journal journal = Journal.create((Location)location);
        TransactionCoordinator txnCoord = new TransactionCoordinator(journal);
        return txnCoord;
    }

    private static String choosePrimaryForIndex(StoreParams params, String index) {
        String primary3 = params.getPrimaryIndexTriples();
        String primary4 = params.getPrimaryIndexQuads();
        if (index.length() == primary3.length()) {
            return primary3;
        }
        if (index.length() == primary4.length()) {
            return primary4;
        }
        throw new DBOpEnvException("Can't find primary for '" + index + "'");
    }

    private static boolean isNewDatabaseArea(Location location) {
        if (location.isMem()) {
            return true;
        }
        File d = new File(location.getDirectoryPath());
        if (!d.exists()) {
            return true;
        }
        FileFilter ff = fileFilterNewDB;
        File[] entries = d.listFiles(ff);
        return entries.length == 0;
    }

    private static void error(Logger log, String msg) {
        if (log != null) {
            log.error(msg);
        }
        throw new TDBException(msg);
    }

    private TDB2StorageBuilder(TransactionalSystem txnSystem, Location location, StoreParams params, ComponentIdMgr componentIdMgr) {
        this.txnSystem = txnSystem;
        this.location = location;
        this.params = params;
        this.componentIdMgr = componentIdMgr;
    }

    private StorageTDB buildStorage() {
        NodeTable nodeTable = this.buildNodeTable(this.params.getNodeTableBaseName(), true);
        TripleTable tripleTable = this.buildTripleTable(nodeTable);
        QuadTable quadTable = this.buildQuadTable(nodeTable);
        StorageTDB dsg = new StorageTDB(this.txnSystem, tripleTable, quadTable);
        return dsg;
    }

    private StoragePrefixes buildPrefixes() {
        NodeTable nodeTablePrefixes = this.buildNodeTable(this.params.getPrefixTableBaseName(), false);
        StoragePrefixesTDB prefixes = this.buildPrefixTable(nodeTablePrefixes);
        return prefixes;
    }

    private TripleTable buildTripleTable(NodeTable nodeTable) {
        String primary = this.params.getPrimaryIndexTriples();
        CharSequence[] indexes = this.params.getTripleIndexes();
        if (indexes.length != 3 && indexes.length != 2) {
            TDB2StorageBuilder.error(log, "Wrong number of triple table indexes: " + String.join((CharSequence)",", indexes));
        }
        log.debug("Triple table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(primary, (String[])indexes);
        if (tripleIndexes.length != indexes.length) {
            TDB2StorageBuilder.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        TripleTable tripleTable = new TripleTable(tripleIndexes, nodeTable);
        return tripleTable;
    }

    private QuadTable buildQuadTable(NodeTable nodeTable) {
        String primary = this.params.getPrimaryIndexQuads();
        CharSequence[] indexes = this.params.getQuadIndexes();
        if (indexes.length != 6 && indexes.length != 4) {
            TDB2StorageBuilder.error(log, "Wrong number of quad table indexes: " + String.join((CharSequence)",", indexes));
        }
        log.debug("Quad table: " + primary + " :: " + String.join((CharSequence)",", indexes));
        TupleIndex[] tripleIndexes = this.makeTupleIndexes(primary, (String[])indexes);
        if (tripleIndexes.length != indexes.length) {
            TDB2StorageBuilder.error(log, "Wrong number of triple table tuples indexes: " + tripleIndexes.length);
        }
        QuadTable tripleTable = new QuadTable(tripleIndexes, nodeTable);
        return tripleTable;
    }

    private StoragePrefixesTDB buildPrefixTable(NodeTable prefixNodes) {
        CharSequence[] indexes;
        String primary = this.params.getPrimaryIndexPrefix();
        TupleIndex[] prefixIndexes = this.makeTupleIndexes(primary, (String[])(indexes = this.params.getPrefixIndexes()));
        if (prefixIndexes.length != 1) {
            TDB2StorageBuilder.error(log, "Wrong number of triple table tuples indexes: " + prefixIndexes.length);
        }
        NodeTupleTableConcrete prefixTable = new NodeTupleTableConcrete(primary.length(), prefixIndexes, prefixNodes);
        StoragePrefixesTDB x = new StoragePrefixesTDB(this.txnSystem, prefixTable);
        log.debug("Prefixes: " + primary + " :: " + String.join((CharSequence)",", indexes));
        return x;
    }

    private TupleIndex[] makeTupleIndexes(String primary, String[] indexNames) {
        int indexRecordLen = primary.length() * 8;
        TupleIndex[] indexes = new TupleIndex[indexNames.length];
        for (int i = 0; i < indexes.length; ++i) {
            String indexName = indexNames[i];
            String indexLabel = indexNames[i];
            indexes[i] = this.makeTupleIndex(primary, indexName, indexLabel);
        }
        return indexes;
    }

    private TupleIndex makeTupleIndex(String primary, String index, String name) {
        TupleMap cmap = TupleMap.create((String)primary, (String)index);
        RecordFactory rf = new RecordFactory(8 * cmap.length(), 0);
        RangeIndex rIdx = this.makeRangeIndex(rf, index);
        TupleIndexRecord tIdx = new TupleIndexRecord(primary.length(), cmap, index, rf, rIdx);
        return tIdx;
    }

    private RangeIndex makeRangeIndex(RecordFactory recordFactory, String name) {
        ComponentId cid = this.componentIdMgr.getComponentId(name);
        FileSet fs = new FileSet(this.location, name);
        BPlusTree bpt = BPlusTreeFactory.createBPTree((ComponentId)cid, (FileSet)fs, (RecordFactory)recordFactory);
        this.components.add((TransactionalComponent)bpt);
        return bpt;
    }

    private NodeTable buildNodeTable(String name, boolean isData) {
        NodeTable nodeTable = this.buildBaseNodeTable(name);
        if ((nodeTable = TDB2StorageBuilder.addNodeTableCache(nodeTable, this.params, isData)) instanceof NodeTableCache) {
            NodeTableCache nodeTableCache = (NodeTableCache)nodeTable;
            this.listeners.add(nodeTableCache);
        }
        nodeTable = NodeTableInline.create(nodeTable);
        return nodeTable;
    }

    private static NodeTable addNodeTableCache(NodeTable nodeTable, StoreParams params, boolean isData) {
        int nodeToIdCacheSize = isData ? params.getNode2NodeIdCacheSize() : params.getPrefixNode2NodeIdCacheSize();
        int idToNodeCacheSize = isData ? params.getNodeId2NodeCacheSize() : params.getPrefixNodeId2NodeCacheSize();
        int missCacheSize = isData ? params.getNodeMissCacheSize() : params.getPrefixNodeMissCacheSize();
        nodeTable = NodeTableCache.create(nodeTable, nodeToIdCacheSize, idToNodeCacheSize, missCacheSize);
        return nodeTable;
    }

    private NodeTable buildBaseNodeTable(String name) {
        RecordFactory recordFactory = new RecordFactory(16, 8);
        RangeIndex index = this.makeRangeIndex(recordFactory, name);
        String dataname = name + "-data";
        TransBinaryDataFile transBinFile = this.makeBinaryDataFile(dataname);
        this.components.add((TransactionalComponent)transBinFile);
        return new NodeTableTRDF((Index)index, (BinaryDataFile)transBinFile);
    }

    private TransBinaryDataFile makeBinaryDataFile(String name) {
        ComponentId cid = this.componentIdMgr.getComponentId(name);
        FileSet fs = new FileSet(this.location, name);
        BinaryDataFile binFile = FileFactory.createBinaryDataFile((FileSet)fs, (String)"obj");
        BufferChannel pState = FileFactory.createBufferChannel((FileSet)fs, (String)"bdf");
        TransBinaryDataFile transBinFile = new TransBinaryDataFile(binFile, cid, pState);
        return transBinFile;
    }
}

