/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import org.fao.geonet.domain.AbstractMetadata_;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.Link;
import org.fao.geonet.domain.LinkStatus_;
import org.fao.geonet.domain.Link_;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataHarvestInfo_;
import org.fao.geonet.domain.MetadataLink_;
import org.fao.geonet.domain.MetadataSourceInfo_;
import org.fao.geonet.domain.Metadata_;
import org.fao.geonet.domain.OperationAllowed;
import org.fao.geonet.domain.OperationAllowedId_;
import org.fao.geonet.domain.OperationAllowed_;
import org.fao.geonet.domain.ReservedOperation;
import org.springframework.data.jpa.domain.Specification;

public class LinkSpecs {
    private LinkSpecs() {
    }

    public static Specification<Link> filter(String urlPartToContain, Integer state, List<String> associatedRecords, Integer[] groupPublishedIds, Integer[] groupOwnerIds, Integer[] httpStatusValueFilter, boolean excludeHarvestedMetadataFilter, Integer[] editingGroupIds) {
        return (Specification & Serializable)(root, query, cb) -> {
            Predicate groupOwnerPredicate;
            Subquery subquery;
            SetJoin metadataJoin;
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (state != null) {
                Path statePath = root.get(Link_.lastState);
                predicates.add(cb.equal((Expression)statePath, (Object)state));
            }
            if (urlPartToContain != null) {
                Path urlPath = root.get(Link_.url);
                predicates.add(cb.like((Expression)urlPath, cb.literal((Object)String.format("%%%s%%", urlPartToContain))));
            }
            if (associatedRecords != null) {
                metadataJoin = root.join(Link_.records, JoinType.INNER);
                predicates.add(metadataJoin.get("metadataUuid").in((Collection)associatedRecords));
            }
            if (excludeHarvestedMetadataFilter) {
                metadataJoin = root.join(Link_.records, JoinType.INNER);
                subquery = query.subquery(Integer.class);
                Root metadataRoot = subquery.from(Metadata.class);
                Path isHarvestedAttributePath = metadataRoot.get(AbstractMetadata_.harvestInfo).get(MetadataHarvestInfo_.harvested_JPAWorkaround);
                Predicate equalHarvestPredicate = cb.equal((Expression)isHarvestedAttributePath, cb.literal((Object)Character.valueOf(Constants.toYN_EnabledChar(false))));
                subquery.where((Expression)equalHarvestPredicate);
                Path metadataId = metadataRoot.get(AbstractMetadata_.id);
                subquery.select((Expression)metadataId);
                predicates.add(metadataJoin.get(MetadataLink_.metadataId).in(new Expression[]{subquery}));
                query.distinct(true);
            }
            if (httpStatusValueFilter != null && httpStatusValueFilter.length > 0) {
                SetJoin linkLinkStatusJoin = root.join(Link_.linkStatus, JoinType.LEFT);
                Integer[] valuesIn = (Integer[])Arrays.stream(httpStatusValueFilter).filter(i -> i >= 0).toArray(Integer[]::new);
                HashSet setValuesNotIn = Sets.newHashSet((Object[])httpStatusValueFilter);
                setValuesNotIn.removeAll(Arrays.asList(valuesIn));
                Integer[] valuesNotIn = (Integer[])setValuesNotIn.stream().map(i -> -1 * i).toArray(Integer[]::new);
                if (valuesIn.length > 0) {
                    predicates.add(cb.and((Expression)cb.equal((Expression)linkLinkStatusJoin.get(LinkStatus_.checkDate), (Expression)root.get(Link_.lastCheck)), (Expression)linkLinkStatusJoin.get(LinkStatus_.statusValue).in(Arrays.asList(Arrays.stream(valuesIn).map(String::valueOf).toArray()))));
                }
                if (valuesNotIn.length > 0) {
                    predicates.add(cb.and((Expression)cb.equal((Expression)linkLinkStatusJoin.get(LinkStatus_.checkDate), (Expression)root.get(Link_.lastCheck)), (Expression)cb.not((Expression)linkLinkStatusJoin.get(LinkStatus_.statusValue).in(Arrays.asList(Arrays.stream(valuesNotIn).map(String::valueOf).toArray())))));
                }
            }
            metadataJoin = root.join(Link_.records, JoinType.INNER);
            subquery = query.subquery(Integer.class);
            Root opAllowRoot = subquery.from(OperationAllowed.class);
            Root metadataRoot = subquery.from(Metadata.class);
            boolean editinGroupQuery = editingGroupIds != null && editingGroupIds.length > 0;
            boolean groupPublishedQuery = groupPublishedIds != null && groupPublishedIds.length > 0;
            boolean groupOwnerQuery = groupOwnerIds != null && groupOwnerIds.length > 0;
            ArrayList<Predicate> subQueryPredicates = new ArrayList<Predicate>();
            if (editinGroupQuery) {
                groupOwnerPredicate = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner).in((Object[])editingGroupIds);
                Predicate metadataOperations = cb.equal((Expression)metadataRoot.get(Metadata_.id), (Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId));
                Predicate editableGroups = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.groupId).in(Arrays.asList(editingGroupIds));
                Predicate operationTypeEdit = cb.equal((Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.operationId), cb.literal((Object)ReservedOperation.editing.getId()));
                subQueryPredicates.add(cb.or((Expression)cb.and((Expression)metadataOperations, (Expression)groupOwnerPredicate), (Expression)cb.and((Expression)editableGroups, (Expression)operationTypeEdit)));
            }
            if (groupPublishedQuery) {
                Predicate publishedToIndicatedGroup = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.groupId).in((Object[])groupPublishedIds);
                Predicate operationTypeView = cb.equal((Expression)opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.operationId), cb.literal((Object)ReservedOperation.view.getId()));
                subQueryPredicates.add(cb.and((Expression)publishedToIndicatedGroup, (Expression)operationTypeView));
            }
            if (groupOwnerQuery) {
                groupOwnerPredicate = metadataRoot.get(Metadata_.sourceInfo).get(MetadataSourceInfo_.groupOwner).in((Object[])groupOwnerIds);
                subQueryPredicates.add(groupOwnerPredicate);
            }
            if (subQueryPredicates.size() > 0) {
                subquery.where(subQueryPredicates.toArray(new Predicate[0]));
                Path opAllowedMetadataId = opAllowRoot.get(OperationAllowed_.id).get(OperationAllowedId_.metadataId);
                subquery.select((Expression)opAllowedMetadataId);
                predicates.add(metadataJoin.get(MetadataLink_.metadataId).in(new Expression[]{subquery}));
            }
            query.distinct(true);
            return cb.and(predicates.toArray(new Predicate[0]));
        };
    }
}

