/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Cacheable;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.fao.geonet.domain.Localized;
import org.fao.geonet.entitylistener.IsoLanguageEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="IsoLanguages")
@EntityListeners(value={IsoLanguageEntityListenerManager.class})
@Cacheable
@SequenceGenerator(name="iso_language_id_seq", initialValue=10000, allocationSize=1)
public class IsoLanguage
extends Localized {
    static final String ID_SEQ_NAME = "iso_language_id_seq";
    private int id;
    private String code;
    private String shortCode;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="iso_language_id_seq")
    public int getId() {
        return this.id;
    }

    public IsoLanguage setId(int id) {
        this.id = id;
        return this;
    }

    @Column(length=3, nullable=false)
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Column(name="shortcode", length=2)
    public String getShortCode() {
        return this.shortCode;
    }

    public void setShortCode(String shortCode) {
        this.shortCode = shortCode;
    }

    @Override
    @ElementCollection(fetch=FetchType.EAGER, targetClass=String.class)
    @CollectionTable(joinColumns={@JoinColumn(name="idDes")}, name="IsoLanguagesDes")
    @MapKeyColumn(name="langId", length=5)
    @Column(name="label", nullable=false)
    public Map<String, String> getLabelTranslations() {
        return super.getLabelTranslations();
    }

    public String toString() {
        return "IsoLanguage{id=" + this.id + ", code='" + this.code + "', shortCode='" + this.shortCode + "'}";
    }
}

