/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributeSource;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaQueryMethod
extends QueryMethod {
    private static final Set<Class<?>> NATIVE_ARRAY_TYPES;
    private static final StoredProcedureAttributeSource storedProcedureAttributeSource;
    private final QueryExtractor extractor;
    private final Method method;
    private final Class<?> returnType;
    @Nullable
    private StoredProcedureAttributes storedProcedureAttributes;
    private final Lazy<LockModeType> lockModeType;
    private final Lazy<QueryHints> queryHints;
    private final Lazy<JpaEntityGraph> jpaEntityGraph;
    private final Lazy<Modifying> modifying;
    private final Lazy<Boolean> isNativeQuery;
    private final Lazy<Boolean> isCollectionQuery;
    private final Lazy<Boolean> isProcedureQuery;
    private final Lazy<JpaEntityMetadata<?>> entityMetadata;

    protected JpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, metadata, factory);
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)extractor, (String)"Query extractor must not be null!");
        this.method = method;
        this.returnType = JpaQueryMethod.potentiallyUnwrapReturnTypeFor(metadata, method);
        this.extractor = extractor;
        this.lockModeType = Lazy.of(() -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Lock.class)).map(AnnotationUtils::getValue).orElse(null));
        this.queryHints = Lazy.of(() -> (QueryHints)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, QueryHints.class));
        this.modifying = Lazy.of(() -> (Modifying)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, Modifying.class));
        this.jpaEntityGraph = Lazy.of(() -> {
            EntityGraph entityGraph = (EntityGraph)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, EntityGraph.class);
            if (entityGraph == null) {
                return null;
            }
            return new JpaEntityGraph(entityGraph, this.getNamedQueryName());
        });
        this.isNativeQuery = Lazy.of(() -> this.getAnnotationValue("nativeQuery", Boolean.class));
        this.isCollectionQuery = Lazy.of(() -> super.isCollectionQuery() && !NATIVE_ARRAY_TYPES.contains(this.returnType));
        this.isProcedureQuery = Lazy.of(() -> AnnotationUtils.findAnnotation((Method)method, Procedure.class) != null);
        this.entityMetadata = Lazy.of(() -> new DefaultJpaEntityMetadata(this.getDomainClass()));
        Assert.isTrue((!this.isModifyingQuery() || !this.getParameters().hasSpecialParameter() ? 1 : 0) != 0, (String)String.format("Modifying method must not contain %s!", Parameters.TYPES));
        this.assertParameterNamesInAnnotatedQuery();
    }

    private static Class<?> potentiallyUnwrapReturnTypeFor(RepositoryMetadata metadata, Method method) {
        TypeInformation returnType = metadata.getReturnType(method);
        while (QueryExecutionConverters.supports((Class)returnType.getType()) || QueryExecutionConverters.supportsUnwrapping((Class)returnType.getType())) {
            returnType = returnType.getRequiredComponentType();
        }
        return returnType.getType();
    }

    private void assertParameterNamesInAnnotatedQuery() {
        String annotatedQuery = this.getAnnotatedQuery();
        if (!DeclaredQuery.of(annotatedQuery, (Boolean)this.isNativeQuery.get()).hasNamedParameter()) {
            return;
        }
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            Parameter parameter = (Parameter)iterator.next();
            if (!parameter.isNamedParameter() || StringUtils.hasText((String)annotatedQuery) && (annotatedQuery.contains(String.format(":%s", parameter.getName().get())) || annotatedQuery.contains(String.format("#%s", parameter.getName().get())))) continue;
            throw new IllegalStateException(String.format("Using named parameters for method %s but parameter '%s' not found in annotated query '%s'!", this.method, parameter.getName(), annotatedQuery));
        }
    }

    public JpaEntityMetadata<?> getEntityInformation() {
        return (JpaEntityMetadata)this.entityMetadata.get();
    }

    public boolean isModifyingQuery() {
        return this.modifying.getNullable() != null;
    }

    List<QueryHint> getHints() {
        QueryHints hints = (QueryHints)this.queryHints.getNullable();
        if (hints != null) {
            return Arrays.asList(hints.value());
        }
        return Collections.emptyList();
    }

    @Nullable
    LockModeType getLockModeType() {
        return (LockModeType)this.lockModeType.getNullable();
    }

    @Nullable
    JpaEntityGraph getEntityGraph() {
        return (JpaEntityGraph)this.jpaEntityGraph.getNullable();
    }

    boolean applyHintsToCountQuery() {
        QueryHints hints = (QueryHints)this.queryHints.getNullable();
        return hints != null ? hints.forCounting() : false;
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Class<?> getReturnType() {
        return this.returnType;
    }

    @Nullable
    String getAnnotatedQuery() {
        String query = this.getAnnotationValue("value", String.class);
        return StringUtils.hasText((String)query) ? query : null;
    }

    boolean hasAnnotatedQueryName() {
        return StringUtils.hasText((String)this.getAnnotationValue("name", String.class));
    }

    String getRequiredAnnotatedQuery() throws IllegalStateException {
        String query = this.getAnnotatedQuery();
        if (query != null) {
            return query;
        }
        throw new IllegalStateException(String.format("No annotated query found for query method %s!", this.getName()));
    }

    @Nullable
    String getCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText((String)countQuery) ? countQuery : null;
    }

    @Nullable
    String getCountQueryProjection() {
        String countProjection = this.getAnnotationValue("countProjection", String.class);
        return StringUtils.hasText((String)countProjection) ? countProjection : null;
    }

    boolean isNativeQuery() {
        return (Boolean)this.isNativeQuery.get();
    }

    public String getNamedQueryName() {
        String annotatedName = this.getAnnotationValue("name", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    String getNamedCountQueryName() {
        String annotatedName = this.getAnnotationValue("countName", String.class);
        return StringUtils.hasText((String)annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    boolean getFlushAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("flushAutomatically", Modifying.class, Boolean.class);
    }

    boolean getClearAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("clearAutomatically", Modifying.class, Boolean.class);
    }

    private <T> T getAnnotationValue(String attribute, Class<T> type) {
        return this.getMergedOrDefaultAnnotationValue(attribute, Query.class, type);
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, (Class)annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue((Class)annotationType, (String)attribute));
        }
        return targetType.cast(AnnotationUtils.getValue((Annotation)annotation, (String)attribute));
    }

    protected JpaParameters createParameters(Method method) {
        return new JpaParameters(method);
    }

    public JpaParameters getParameters() {
        return (JpaParameters)super.getParameters();
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isProcedureQuery() {
        return (Boolean)this.isProcedureQuery.get();
    }

    StoredProcedureAttributes getProcedureAttributes() {
        if (this.storedProcedureAttributes == null) {
            this.storedProcedureAttributes = storedProcedureAttributeSource.createFrom(this.method, (JpaEntityMetadata<?>)this.getEntityInformation());
        }
        return this.storedProcedureAttributes;
    }

    static {
        storedProcedureAttributeSource = StoredProcedureAttributeSource.INSTANCE;
        HashSet<Class> types = new HashSet<Class>();
        types.add(byte[].class);
        types.add(Byte[].class);
        types.add(char[].class);
        types.add(Character[].class);
        NATIVE_ARRAY_TYPES = Collections.unmodifiableSet(types);
    }
}

