/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.xpath;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.data.complex.feature.xpath.AttributeNodePointer;

public class AttributeNodeIterator
implements NodeIterator {
    AttributeNodePointer pointer;
    ComplexAttribute feature;
    List<Property> children;
    int position;

    public AttributeNodeIterator(AttributeNodePointer pointer) {
        this.pointer = pointer;
        this.feature = (ComplexAttribute)pointer.getImmediateAttribute();
        this.children = new ArrayList<Property>(this.feature.getValue());
        this.position = 1;
    }

    public AttributeNodeIterator(AttributeNodePointer pointer, Name name) {
        this.pointer = pointer;
        this.feature = (ComplexAttribute)pointer.getImmediateAttribute();
        AttributeDescriptor descriptor = this.feature.getDescriptor();
        Name attName = descriptor == null ? this.feature.getType().getName() : descriptor.getName();
        this.children = attName.equals((Object)name) ? Collections.singletonList(this.feature) : new ArrayList<Property>(this.feature.getProperties(name));
        this.position = this.children.isEmpty() ? 0 : 1;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean setPosition(int position) {
        this.position = position;
        return position <= this.children.size();
    }

    public NodePointer getNodePointer() {
        Attribute attribute = (Attribute)this.children.get(this.position - 1);
        Name name = attribute.getDescriptor().getName();
        QName qname = new QName(name.getNamespaceURI(), name.getLocalPart());
        return new AttributeNodePointer(this.pointer, attribute, qname);
    }
}

