/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.api.filter.identity;

import java.util.Date;

public final class Version {
    static final long UNION_MASK = 0xFFFFFFFFFFFFFFFL;
    static final long UNION_INTEGER = 0x1000000000000000L;
    static final long UNION_DATE = 0x2000000000000000L;
    static final long UNION_ACTION = 0x4000000000000000L;
    final long union;

    public Version() {
        this.union = 0L;
    }

    private Version(long union) {
        this.union = union;
    }

    public static Version valueOf(long union) {
        return new Version(union);
    }

    public Version(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action can't be null");
        }
        this.union = 0x4000000000000000L | (long)action.ordinal();
    }

    public Version(Integer index) {
        if (index == null) {
            throw new IllegalArgumentException("index can't be null");
        }
        if (0 >= index) {
            throw new IllegalArgumentException("Invalid version index: " + index + ". Must be a positive integer > 0.");
        }
        this.union = 0x1000000000000000L | (long)index.intValue();
    }

    public Version(Date dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException("dateTime can't be null");
        }
        this.union = 0x2000000000000000L | dateTime.getTime();
    }

    public boolean isEmpty() {
        return this.union == 0L;
    }

    public boolean isVersionAction() {
        return (0x4000000000000000L & this.union) > 0L;
    }

    public long union() {
        return this.union;
    }

    public Action getVersionAction() {
        if ((0x4000000000000000L & this.union) > 0L) {
            int ordinal = (int)(this.union & 0xFFFFFFFFFFFFFFFL);
            Action action = Action.lookup(ordinal);
            return action;
        }
        return null;
    }

    public boolean isIndex() {
        return (0x1000000000000000L & this.union) > 0L;
    }

    public Integer getIndex() {
        if ((0x1000000000000000L & this.union) > 0L) {
            int index = (int)(this.union & 0xFFFFFFFFFFFFFFFL);
            return index;
        }
        return null;
    }

    public boolean isDateTime() {
        return (0x2000000000000000L & this.union) > 0L;
    }

    public Date getDateTime() {
        if ((0x2000000000000000L & this.union) > 0L) {
            long time = this.union & 0xFFFFFFFFFFFFFFFL;
            return new Date(time);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Version)) {
            return false;
        }
        Version v = (Version)o;
        return this.union == v.union;
    }

    public int hashCode() {
        return 17 * (int)this.union;
    }

    public static enum Action {
        FIRST,
        LAST,
        NEXT,
        PREVIOUS,
        ALL;


        public static Action lookup(int ordinal) {
            for (Action action : Action.values()) {
                if (action.ordinal() != ordinal) continue;
                return action;
            }
            return null;
        }
    }
}

