/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.DataQuery;
import org.openrdf.sesame.query.rql.model.iterators.NestedValueIterator;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sail.util.EmptyValueIterator;

public class InstanceOf
implements DataQuery {
    protected ClassQuery _classQ;
    protected boolean _properInstances;

    public InstanceOf(ClassQuery classQ, boolean properInstances) {
        this._classQ = classQ;
        this._properInstances = properInstances;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter = null;
        try {
            listener.startTableQueryResult();
            iter = this.getInstances(rss);
            while (iter.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter.next());
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getInstances(rss);
    }

    public ValueIterator getInstances(RdfSchemaSource rss) throws QueryEvaluationException {
        ResourceIterator classIter = this._classQ.getClasses(rss);
        return new Iterator(rss, classIter);
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        if (this._properInstances) {
            return "^" + this._classQ.toString();
        }
        return this._classQ.toString();
    }

    class Iterator
    extends NestedValueIterator {
        protected RdfSchemaSource _rss;

        public Iterator(RdfSchemaSource rss, ResourceIterator classIter) {
            super(classIter);
            this._rss = rss;
        }

        public ValueIterator getInnerIterator(Resource classRes) {
            if (classRes.equals(URIImpl.RDFS_LITERAL)) {
                return new EmptyValueIterator();
            }
            StatementIterator statIter = InstanceOf.this._properInstances ? this._rss.getDirectType(null, classRes) : this._rss.getType(null, classRes);
            return new StatementSubjectIterator(statIter);
        }
    }
}

