/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ExternalMark;
import org.geotools.api.style.Fill;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleFactoryImpl;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class MarkImpl
implements Mark,
Cloneable,
Symbol {
    private static final Logger LOGGER = Logging.getLogger(MarkImpl.class);
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private StrokeImpl stroke;
    private ExternalMarkImpl external;
    private Expression wellKnownName = null;

    public MarkImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
    }

    public MarkImpl(String name) {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()), null);
        LOGGER.fine("creating " + name + " type mark");
        this.setWellKnownName(name);
    }

    public MarkImpl(FilterFactory filterFactory, ExternalMark external) {
        this.filterFactory = filterFactory;
        LOGGER.fine("creating defaultMark");
        try {
            StyleFactoryImpl sfac = new StyleFactoryImpl();
            this.fill = FillImpl.cast(sfac.getDefaultFill());
            this.stroke = StrokeImpl.cast(sfac.getDefaultStroke());
            this.wellKnownName = filterFactory.literal((Object)"square");
        }
        catch (IllegalFilterException ife) {
            MarkImpl.severe("<init>", "Failed to build default mark: ", ife);
        }
        this.external = ExternalMarkImpl.cast(external);
    }

    private static void severe(String method, String message, Exception exception) {
        LogRecord record = new LogRecord(Level.SEVERE, message);
        record.setSourceMethodName(method);
        record.setThrown(exception);
        LOGGER.log(record);
    }

    public FillImpl getFill() {
        return this.fill;
    }

    public StrokeImpl getStroke() {
        return this.stroke;
    }

    public Expression getWellKnownName() {
        return this.wellKnownName;
    }

    public void setFill(Fill fill) {
        this.fill = FillImpl.cast(fill);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = StrokeImpl.cast(stroke);
    }

    public void setWellKnownName(Expression wellKnownName) {
        LOGGER.entering("DefaultMark", "setWellKnownName");
        this.wellKnownName = wellKnownName;
    }

    public void setWellKnownName(String name) {
        this.setWellKnownName((Expression)this.filterFactory.literal((Object)name));
    }

    public String toString() {
        return this.wellKnownName.toString();
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((Mark)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Mark)this);
    }

    public Object clone() {
        try {
            MarkImpl clone = (MarkImpl)super.clone();
            if (this.fill != null) {
                clone.fill = (FillImpl)this.fill.clone();
            }
            if (this.stroke != null && this.stroke instanceof Cloneable) {
                clone.stroke = (StrokeImpl)this.stroke.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone MarkImpl");
        }
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.fill != null) {
            result = 1000003 * result + this.fill.hashCode();
        }
        if (this.stroke != null) {
            result = 1000003 * result + this.stroke.hashCode();
        }
        if (this.wellKnownName != null) {
            result = 1000003 * result + this.wellKnownName.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth.getClass() != this.getClass()) {
            return false;
        }
        MarkImpl other = (MarkImpl)oth;
        if (this.wellKnownName == null ? other.wellKnownName != null : !this.wellKnownName.equals(other.wellKnownName)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        return !(this.stroke == null ? other.stroke != null : !this.stroke.equals(other.stroke));
    }

    public ExternalMarkImpl getExternalMark() {
        return this.external;
    }

    public void setExternalMark(ExternalMark external) {
        this.external = ExternalMarkImpl.cast(external);
    }

    static MarkImpl cast(GraphicalSymbol item) {
        if (item == null) {
            return null;
        }
        if (item instanceof MarkImpl) {
            return (MarkImpl)item;
        }
        if (item instanceof Mark) {
            Mark mark = (Mark)item;
            MarkImpl copy = new MarkImpl();
            copy.setStroke(mark.getStroke());
            copy.setWellKnownName(mark.getWellKnownName());
            copy.setExternalMark(mark.getExternalMark());
            return copy;
        }
        return null;
    }
}

