/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.openidconnect;

import org.fao.geonet.kernel.security.openidconnect.GeonetworkClientRegistrationProvider;
import org.fao.geonet.kernel.security.openidconnect.bearer.GeonetworkClientServiceAccountRegistrationProvider;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;

public class GeonetworkClientRegistrationRepository
implements ClientRegistrationRepository {
    ClientRegistration clientRegistration;
    ClientRegistration clientServiceAccountRegistration;

    public GeonetworkClientRegistrationRepository(GeonetworkClientRegistrationProvider clientRegistrationProvider) throws Exception {
        if (clientRegistrationProvider == null) {
            throw new Exception("clientRegistration must not be null!");
        }
        this.clientRegistration = clientRegistrationProvider.getClientRegistration();
        this.clientServiceAccountRegistration = null;
    }

    public GeonetworkClientRegistrationRepository(GeonetworkClientRegistrationProvider clientRegistrationProvider, GeonetworkClientRegistrationProvider clientServiceAccountRegistrationProvider) throws Exception {
        if (clientRegistrationProvider == null) {
            throw new Exception("clientRegistration must not be null!");
        }
        this.clientRegistration = clientRegistrationProvider.getClientRegistration();
        this.clientServiceAccountRegistration = clientServiceAccountRegistrationProvider.getClientRegistration();
    }

    public ClientRegistration findByRegistrationId(String registrationId) {
        if ("geonetwork-oidc".equals(registrationId)) {
            return this.clientRegistration;
        }
        if (GeonetworkClientServiceAccountRegistrationProvider.CLIENT_SERVICE_ACCOUNT_REGISTRATION_NAME.equals(registrationId)) {
            return this.clientServiceAccountRegistration;
        }
        return null;
    }
}

