/*
 * Decompiled with CFR 0.152.
 */
package jeeves.xlink;

import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.URIMapper;
import jeeves.xlink.XLink;
import org.apache.commons.lang.StringUtils;
import org.apache.jcs.access.exception.CacheException;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.JeevesJCS;
import org.fao.geonet.kernel.SpringLocalServiceInvoker;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public final class Processor {
    public static final String XLINK_JCS = "xlink";
    private static final int MAX_FAILURES = 50;
    private static final long ELAPSE_TIME = 30000L;
    private static final String ACTION_REMOVE = "remove";
    private static final String ACTION_RESOLVE = "resolve";
    private static final String ACTION_UNCACHE = "uncache";
    private static final String ACTION_DETACH = "detach";
    private static CopyOnWriteArraySet<URIMapper> uriMapper = new CopyOnWriteArraySet();

    private Processor() {
    }

    public static Set<String> processXLink(Element xml, ServiceContext srvContext) {
        HashSet errors = Sets.newHashSet();
        errors.addAll(Processor.searchXLink(xml, ACTION_RESOLVE, srvContext));
        errors.addAll(Processor.searchLocalXLink(xml, ACTION_RESOLVE));
        return errors;
    }

    public static Element removeXLink(Element xml) {
        Processor.searchXLink(xml, ACTION_REMOVE, null);
        Processor.searchLocalXLink(xml, ACTION_REMOVE);
        return xml;
    }

    public static Element detachXLink(Element xml, ServiceContext context) {
        Processor.searchXLink(xml, ACTION_DETACH, context);
        Processor.searchLocalXLink(xml, ACTION_DETACH);
        return xml;
    }

    public static List<Attribute> getXLinks(Element md) {
        return Processor.getXLinksWithXPath(md, "*//@xlink:href");
    }

    public static void clearCache() throws CacheException {
        JeevesJCS.getInstance((String)XLINK_JCS).clear();
    }

    public static void addXLinkToCache(String uri, Element fragment) throws CacheException {
        JeevesJCS xlinkCache = JeevesJCS.getInstance((String)XLINK_JCS);
        Element cachedFragment = (Element)xlinkCache.get((Object)uri.toLowerCase());
        if (cachedFragment == null) {
            xlinkCache.put((Object)uri.toLowerCase(), (Object)fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static Element resolveXLink(String uri, String idSearch, ServiceContext srvContext) throws IOException, JDOMException, CacheException {
        block17: {
            remoteFragment = null;
            try {
                if (uri.startsWith("local://")) {
                    springLocalServiceInvoker = srvContext.getBean(SpringLocalServiceInvoker.class);
                    remoteFragment = (Element)springLocalServiceInvoker.invoke(uri);
                    break block17;
                }
                if (uri.toLowerCase().startsWith("file://")) {
                    return null;
                }
                uri = uri.replaceAll("&+", "&");
                mappedURI = Processor.mapURI(uri);
                xlinkCache = JeevesJCS.getInstance((String)"xlink");
                remoteFragment = (Element)xlinkCache.getFromGroup((Object)uri.toLowerCase(), mappedURI);
                if (remoteFragment == null) {
                    Log.info((String)"jeeves.xlinkprocessor", (Object)("cache MISS on " + uri.toLowerCase()));
                    url = new URL(uri.replaceAll("&amp;", "&"));
                    conn = url.openConnection();
                    conn.setConnectTimeout(1000);
                    in = new BufferedInputStream(conn.getInputStream());
                    try {
                        remoteFragment = Xml.loadStream((InputStream)in);
                        if (!Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) ** GOTO lbl28
                        Log.debug((String)"jeeves.xlinkprocessor", (Object)("Read:\n" + Xml.getString((Element)remoteFragment)));
                    }
                    finally {
                        in.close();
                    }
                } else {
                    Log.debug((String)"jeeves.xlinkprocessor", (Object)("cache HIT on " + uri.toLowerCase()));
                }
lbl28:
                // 3 sources

                if (remoteFragment != null && !remoteFragment.getName().equalsIgnoreCase("error")) {
                    xlinkCache.putInGroup((Object)uri.toLowerCase(), mappedURI, (Object)remoteFragment);
                    if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
                        Log.debug((String)"jeeves.xlinkprocessor", (Object)("cache miss for " + uri));
                    }
                    break block17;
                }
                return null;
            }
            catch (Exception e) {
                Log.error((String)"jeeves.xlinkprocessor", (String)("Failed on " + uri), (Throwable)e);
            }
        }
        res = null;
        if (idSearch != null) {
            xpath = "*//*[@id='" + idSearch + "']";
            try {
                res = Xml.selectElement((Element)remoteFragment, (String)xpath);
                if (res == null) ** GOTO lbl53
                res = (Element)res.clone();
                res.removeAttribute("id");
            }
            catch (Exception e) {
                Log.warning((String)"jeeves.xlinkprocessor", (Object)("Failed to search for remote fragment using " + xpath + ", error" + e.getMessage()));
                return null;
            }
        } else {
            if (remoteFragment == null) {
                return null;
            }
            res = (Element)remoteFragment.clone();
        }
lbl53:
        // 3 sources

        if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
            Log.debug((String)"jeeves.xlinkprocessor", (Object)("Read:" + Xml.getString((Element)res)));
        }
        return res;
    }

    public static String mapURI(String uri) {
        uri = uri.replaceAll("&+", "&").toLowerCase();
        for (URIMapper mapper : uriMapper) {
            uri = mapper.map(uri);
        }
        return uri;
    }

    public static void uncacheXLinkUri(String uri) throws CacheException {
        String mappedURI;
        JeevesJCS xlinkCache = JeevesJCS.getInstance((String)XLINK_JCS);
        Set groupKeys = xlinkCache.getGroupKeys(mappedURI = Processor.mapURI(uri));
        if (groupKeys == null || groupKeys.isEmpty()) {
            xlinkCache.remove((Object)uri);
        } else {
            for (Object key : groupKeys) {
                xlinkCache.remove(key, mappedURI);
            }
        }
    }

    private static List<Attribute> getXLinksWithXPath(Element md, String xpath) {
        ArrayList<Namespace> theNss = new ArrayList<Namespace>();
        theNss.add(XLink.NAMESPACE_XLINK);
        ArrayList<Attribute> xlinks = new ArrayList();
        try {
            xlinks = Xml.selectNodes((Element)md, (String)xpath, theNss);
        }
        catch (Exception e) {
            Log.error((String)"jeeves.xlinkprocessor", (String)e.getMessage(), (Throwable)e);
        }
        return xlinks;
    }

    private static Set<String> searchXLink(Element md, String action, ServiceContext srvContext) {
        List<Attribute> xlinks = Processor.getXLinksWithXPath(md, "*//@xlink:href");
        if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
            Log.debug((String)"jeeves.xlinkprocessor", (Object)("returned " + xlinks.size() + " elements"));
        }
        HashSet errors = Sets.newHashSet();
        for (Attribute xlink : xlinks) {
            String idSearch;
            String error;
            String hrefUri = xlink.getValue();
            if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
                Log.debug((String)"jeeves.xlinkprocessor", (Object)("will resolve href '" + hrefUri + "'"));
            }
            if ((error = Processor.doXLink(hrefUri, idSearch = null, xlink, action, srvContext)) == null) continue;
            errors.add(error);
        }
        return errors;
    }

    private static Set<String> searchLocalXLink(Element md, String action) {
        List<Attribute> xlinks = Processor.getXLinksWithXPath(md, "*//@xlink:href[starts-with(.,'#')]");
        if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
            Log.debug((String)"jeeves.xlinkprocessor", (Object)("local xlink search returned " + xlinks.size() + " elements"));
        }
        HashSet errors = Sets.newHashSet();
        HashMap<String, Element> localIds = new HashMap<String, Element>();
        for (Attribute xlink : xlinks) {
            Element element = xlink.getParent();
            if (action.equals(ACTION_REMOVE)) {
                element.getParentElement().removeAttribute("show", XLink.NAMESPACE_XLINK);
                element.removeContent();
            } else {
                String idSearch = xlink.getValue().substring(1);
                if (Log.isDebugEnabled((String)"jeeves.xlinkprocessor")) {
                    Log.debug((String)"jeeves.xlinkprocessor", (Object)("process local xlink '" + idSearch + "'"));
                }
                Element localFragment = (Element)localIds.get(idSearch);
                try {
                    List<Attribute> subXlinks;
                    if (localFragment == null) {
                        localFragment = Xml.selectElement((Element)md, (String)("*//*[@id='" + idSearch + "']"));
                        localIds.put(idSearch, localFragment);
                    }
                    if ((subXlinks = Processor.getXLinksWithXPath(localFragment, "*//@xlink:href[.='#" + idSearch + "']")).size() != 0) {
                        Log.warning((String)"jeeves.xlinkprocessor", (Object)("found a fragment " + Xml.getString((Element)localFragment) + " containing " + subXlinks.size() + " reference(s) to itself. Id: " + idSearch));
                        continue;
                    }
                }
                catch (Exception e) {
                    Log.error((String)"jeeves.xlinkprocessor", (String)("Failed to look up localxlink " + idSearch + ": " + e.getMessage()), (Throwable)e);
                }
                if (localFragment != null) {
                    localFragment = (Element)localFragment.clone();
                    localFragment.removeAttribute("id");
                    element.removeContent();
                    element.addContent((Content)localFragment);
                } else {
                    errors.add(xlink.getValue());
                }
            }
            Processor.cleanXLinkAttributes(element, action);
        }
        return errors;
    }

    private static String doXLink(String hrefUri, String idSearch, Attribute xlink, String action, ServiceContext srvContext) {
        Element element = xlink.getParent();
        ArrayList<String> excludedXlinkElements = new ArrayList<String>();
        SettingManager sm = (SettingManager)ApplicationContextHolder.get().getBean(SettingManager.class);
        String xlinkElementNamesToIgnore = sm.getValue("system/xlinkResolver/ignore");
        if (StringUtils.isNotEmpty((String)xlinkElementNamesToIgnore)) {
            for (String el : xlinkElementNamesToIgnore.split(",")) {
                excludedXlinkElements.add(el.trim());
            }
        }
        if (excludedXlinkElements.contains(element.getName())) {
            return null;
        }
        if (!hrefUri.equals("")) {
            String show = element.getAttributeValue("show", XLink.NAMESPACE_XLINK);
            if (show == null || show.equals("")) {
                show = "embed";
            }
            if (show.equalsIgnoreCase("embed") || show.equalsIgnoreCase("replace")) {
                if (action.equals(ACTION_REMOVE)) {
                    element.removeContent();
                } else if (action.equals(ACTION_UNCACHE)) {
                    try {
                        Processor.uncacheXLinkUri(hrefUri);
                    }
                    catch (Exception e) {
                        Log.error((String)"jeeves.xlinkprocessor", (String)("Uncaching failed: " + e.getMessage()), (Throwable)e);
                    }
                } else {
                    try {
                        Element remoteFragment = Processor.resolveXLink(hrefUri, idSearch, srvContext);
                        if (remoteFragment == null) {
                            return hrefUri;
                        }
                        Processor.searchXLink(remoteFragment, action, srvContext);
                        if (show.equalsIgnoreCase("replace")) {
                            if (!action.equals(ACTION_DETACH) && show.equalsIgnoreCase("replace")) {
                                remoteFragment.setAttribute((Attribute)xlink.clone());
                                remoteFragment.setAttribute(new Attribute("show", "replace", XLink.NAMESPACE_XLINK));
                            }
                            Element parent = element.getParentElement();
                            int index = parent.indexOf((Content)element);
                            parent.setContent(index, (Content)remoteFragment);
                        } else {
                            element.removeContent();
                            element.addContent((Content)remoteFragment);
                        }
                    }
                    catch (Exception e) {
                        Log.error((String)"jeeves.xlinkprocessor", (String)("doXLink " + action + " failed: " + e.getMessage()), (Throwable)e);
                    }
                }
                Processor.cleanXLinkAttributes(element, action);
            } else {
                Log.error((String)"jeeves.xlinkprocessor", (Object)("Invalid xlink:show attribute '" + show + "'"));
            }
        }
        return null;
    }

    private static void cleanXLinkAttributes(Element element, String action) {
        if (action.equals(ACTION_DETACH)) {
            element.removeAttribute("href", XLink.NAMESPACE_XLINK);
            element.removeAttribute("role", XLink.NAMESPACE_XLINK);
            element.removeAttribute("title", XLink.NAMESPACE_XLINK);
        }
    }
}

