/*
 * Decompiled with CFR 0.152.
 */
package org.mapfish.print.config.layout;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapfish.print.InvalidValueException;
import org.mapfish.print.PDFUtils;
import org.mapfish.print.RenderingContext;
import org.mapfish.print.config.ColorWrapper;
import org.mapfish.print.config.layout.HorizontalAlign;
import org.mapfish.print.config.layout.MapBlock;
import org.mapfish.print.config.layout.VerticalAlign;
import org.mapfish.print.utils.PJsonObject;

public abstract class Block {
    protected HorizontalAlign align = null;
    private VerticalAlign vertAlign = null;
    private String backgroundColor = null;
    private String condition = null;
    protected double spacingAfter = 0.0;
    private boolean renderOnExtraPage;
    public static final Pattern CONDITION_REGEXP = Pattern.compile("^(!?)(.*)$");

    public abstract void render(PJsonObject var1, PdfElement var2, RenderingContext var3) throws DocumentException;

    public MapBlock getMap(String name) {
        return null;
    }

    public void validate() {
    }

    public boolean isAbsolute() {
        return false;
    }

    public void setAlign(HorizontalAlign align) {
        this.align = align;
    }

    public void setVertAlign(VerticalAlign vertAlign) {
        this.vertAlign = vertAlign;
    }

    public Color getBackgroundColorVal(RenderingContext context, PJsonObject params) {
        return ColorWrapper.convertColor(PDFUtils.evalString(context, params, this.backgroundColor, null));
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public HorizontalAlign getAlign() {
        return this.align;
    }

    public VerticalAlign getVertAlign() {
        return this.vertAlign;
    }

    public static final boolean testCondition(RenderingContext context, PJsonObject params, String condition) {
        boolean result;
        if (condition == null) {
            return true;
        }
        Matcher matcher = CONDITION_REGEXP.matcher(condition);
        if (!matcher.matches()) {
            throw new InvalidValueException("condition", condition);
        }
        String value = params.optString(matcher.group(2));
        if (value == null) {
            value = context.getGlobalParams().optString(matcher.group(2));
        }
        boolean bl = result = value != null && value.length() > 0 && !value.equals("0") && !value.equalsIgnoreCase("false");
        if (matcher.group(1).equals("!")) {
            result = !result;
        }
        return result;
    }

    public boolean isVisible(RenderingContext context, PJsonObject params) {
        return Block.testCondition(context, params, this.condition);
    }

    public void setCondition(String condition) {
        this.condition = condition;
        if (condition != null && !CONDITION_REGEXP.matcher(condition).matches()) {
            throw new InvalidValueException("condition", condition);
        }
    }

    public void setSpacingAfter(double spacingAfter) {
        this.spacingAfter = spacingAfter;
        if (spacingAfter < 0.0) {
            throw new InvalidValueException("spacingAfter", spacingAfter);
        }
    }

    protected double getMaxValueIfZero(double value, String exceptionName) {
        if (value < 0.0) {
            throw new InvalidValueException(exceptionName, value);
        }
        return value == 0.0 ? Double.MAX_VALUE : value;
    }

    protected float getMaxValueIfZero(float value, String exceptionName) {
        if ((double)value < 0.0) {
            throw new InvalidValueException(exceptionName, value);
        }
        return (double)value == 0.0 ? Float.MAX_VALUE : value;
    }

    public boolean hasExtraRendering() {
        return false;
    }

    public boolean isRenderOnExtraPage() {
        return this.renderOnExtraPage;
    }

    public void setRenderOnExtraPage(boolean renderOnExtraPage) {
        this.renderOnExtraPage = renderOnExtraPage;
    }

    public static interface PdfElement {
        public void add(Element var1) throws DocumentException;
    }
}

