/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.graph.Graph;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.HttpRDF;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.web.HttpSC;

public class AsyncHttpRDF {
    private static Consumer<HttpRequest.Builder> acceptHeaderGraph = HttpLib.setAcceptHeader("text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
    private static Consumer<HttpRequest.Builder> acceptHeaderDatasetGraph = HttpLib.setAcceptHeader("application/trig,application/n-quads;q=0.9,application/ld+json;q=0.8,*/*;q=0.3");

    public static CompletableFuture<Graph> asyncGetGraph(String url) {
        return AsyncHttpRDF.asyncGetGraph(HttpEnv.getDftHttpClient(), url);
    }

    public static CompletableFuture<Graph> asyncGetGraph(HttpClient httpClient, String url) {
        Objects.requireNonNull(httpClient, "HttpClient");
        Objects.requireNonNull(url, "URL");
        Graph graph = GraphFactory.createDefaultGraph();
        StreamRDF dest = StreamRDFLib.graph(graph);
        CompletableFuture<Void> cf = AsyncHttpRDF.asyncGetToStream(httpClient, url, acceptHeaderGraph, dest, null);
        return cf.thenApply(x -> graph);
    }

    public static CompletableFuture<DatasetGraph> asyncGetDatasetGraph(String url) {
        return AsyncHttpRDF.asyncGetDatasetGraph(HttpEnv.getDftHttpClient(), url);
    }

    public static CompletableFuture<DatasetGraph> asyncGetDatasetGraph(HttpClient httpClient, String url) {
        Objects.requireNonNull(httpClient, "HttpClient");
        Objects.requireNonNull(url, "URL");
        DatasetGraph dsg = DatasetGraphFactory.createTxnMem();
        StreamRDF dest = StreamRDFLib.dataset(dsg);
        CompletableFuture<Void> cf = AsyncHttpRDF.asyncGetToStream(httpClient, url, acceptHeaderDatasetGraph, dest, (Transactional)dsg);
        return cf.thenApply(x -> dsg);
    }

    public static CompletableFuture<Void> asyncLoadDatasetGraph(String url, DatasetGraph dsg) {
        return AsyncHttpRDF.asyncLoadDatasetGraph(HttpEnv.getDftHttpClient(), url, dsg);
    }

    public static CompletableFuture<Void> asyncLoadDatasetGraph(HttpClient httpClient, String url, DatasetGraph dsg) {
        Objects.requireNonNull(httpClient, "HttpClient");
        Objects.requireNonNull(url, "URL");
        Objects.requireNonNull(dsg, "dataset");
        StreamRDF dest = StreamRDFLib.dataset(dsg);
        return AsyncHttpRDF.asyncGetToStream(httpClient, url, acceptHeaderDatasetGraph, dest, (Transactional)dsg);
    }

    public static CompletableFuture<Void> asyncLoadDatasetGraph(HttpClient httpClient, String url, Map<String, String> headers, DatasetGraph dsg) {
        Objects.requireNonNull(httpClient, "HttpClient");
        Objects.requireNonNull(url, "URL");
        Objects.requireNonNull(dsg, "dataset");
        StreamRDF dest = StreamRDFLib.dataset(dsg);
        return AsyncHttpRDF.asyncGetToStream(httpClient, url, HttpLib.setHeaders(headers), dest, (Transactional)dsg);
    }

    public static CompletableFuture<Void> asyncGetToStream(HttpClient httpClient, String url, String acceptHeader, StreamRDF dest, Transactional transactional) {
        Objects.requireNonNull(httpClient, "HttpClient");
        Objects.requireNonNull(url, "URL");
        Objects.requireNonNull(dest, "StreamRDF");
        Consumer<HttpRequest.Builder> setAcceptHeader = HttpLib.setAcceptHeader(acceptHeader);
        return AsyncHttpRDF.asyncGetToStream(httpClient, url, setAcceptHeader, dest, transactional);
    }

    private static CompletableFuture<Void> asyncGetToStream(HttpClient httpClient, String url, Consumer<HttpRequest.Builder> modifier, StreamRDF dest, Transactional _transactional) {
        CompletableFuture<HttpResponse<InputStream>> cf = AsyncHttpRDF.asyncGetToInput(httpClient, url, modifier);
        Transactional transact = _transactional == null ? TransactionalNull.create() : _transactional;
        return cf.thenApply(httpResponse -> {
            transact.executeWrite(() -> HttpRDF.httpResponseToStreamRDF(url, httpResponse, dest));
            return null;
        });
    }

    public static void syncOrElseThrow(CompletableFuture<Void> cf) {
        AsyncHttpRDF.getOrElseThrow(cf);
    }

    public static <T> T getOrElseThrow(CompletableFuture<T> cf) {
        Objects.requireNonNull(cf);
        try {
            return cf.join();
        }
        catch (CompletionException ex) {
            if (ex.getCause() != null) {
                Throwable cause = ex.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof IOException) {
                    IOException iox = (IOException)cause;
                    if (iox.getMessage().contains("too many authentication attempts") || iox.getMessage().contains("No credentials provided")) {
                        throw new HttpException(401, HttpSC.getMessage(401));
                    }
                    IO.exception((IOException)((IOException)cause));
                }
            }
            throw ex;
        }
    }

    private static CompletableFuture<HttpResponse<InputStream>> asyncGetToInput(HttpClient httpClient, String url, Consumer<HttpRequest.Builder> modifier) {
        Objects.requireNonNull(httpClient);
        Objects.requireNonNull(url);
        HttpRequest requestData = HttpLib.newGetRequest(url, modifier);
        return HttpLib.asyncExecute(httpClient, requestData);
    }
}

