/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.synonyms;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.analyze.ReloadAnalyzersRequest;
import org.elasticsearch.action.admin.indices.analyze.ReloadAnalyzersResponse;
import org.elasticsearch.action.admin.indices.analyze.TransportReloadAnalyzersAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.synonyms.PagedResult;
import org.elasticsearch.synonyms.SynonymRule;
import org.elasticsearch.synonyms.SynonymSetSummary;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class SynonymsManagementAPIService {
    private static final Logger logger = LogManager.getLogger(SynonymsManagementAPIService.class);
    private static final String SYNONYMS_INDEX_NAME_PATTERN = ".synonyms-*";
    private static final int SYNONYMS_INDEX_FORMAT = 2;
    private static final String SYNONYMS_INDEX_CONCRETE_NAME = ".synonyms-2";
    private static final String SYNONYMS_ALIAS_NAME = ".synonyms";
    public static final String SYNONYMS_FEATURE_NAME = "synonyms";
    public static final String SYNONYMS_SET_FIELD = "synonyms_set";
    public static final String SYNONYMS_FIELD = SynonymRule.SYNONYMS_FIELD.getPreferredName();
    private static final String OBJECT_TYPE_FIELD = "type";
    private static final String SYNONYM_RULE_OBJECT_TYPE = "synonym_rule";
    private static final String SYNONYM_SET_OBJECT_TYPE = "synonym_set";
    private static final String SYNONYM_RULE_ID_SEPARATOR = "|";
    public static final int MAX_SYNONYMS_SETS = 10000;
    private static final String SYNONYM_RULE_ID_FIELD = SynonymRule.ID_FIELD.getPreferredName();
    private static final String SYNONYM_SETS_AGG_NAME = "synonym_sets_aggr";
    private static final int SYNONYMS_INDEX_MAPPINGS_VERSION = 1;
    private final Client client;
    public static final String SYNONYMS_ORIGIN = "synonyms";
    public static final SystemIndexDescriptor SYNONYMS_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".synonyms-*").setDescription("Synonyms index for synonyms managed through APIs").setPrimaryIndex(".synonyms-2").setAliasName(".synonyms").setIndexFormat(2).setMappings(SynonymsManagementAPIService.mappings()).setSettings(SynonymsManagementAPIService.settings()).setVersionMetaKey("version").setOrigin("synonyms").build();

    public SynonymsManagementAPIService(Client client) {
        this.client = new OriginSettingClient(client, "synonyms");
    }

    private static XContentBuilder mappings() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            builder.startObject("_doc");
            builder.startObject("_meta");
            builder.field("version", Version.CURRENT.toString());
            builder.field("managed_index_mappings_version", 1);
            builder.endObject();
            builder.field("dynamic", "strict");
            builder.startObject("properties");
            builder.startObject(SYNONYM_RULE_ID_FIELD);
            builder.field(OBJECT_TYPE_FIELD, "keyword");
            builder.endObject();
            builder.startObject(SYNONYMS_FIELD);
            builder.field(OBJECT_TYPE_FIELD, "match_only_text");
            builder.endObject();
            builder.startObject(SYNONYMS_SET_FIELD);
            builder.field(OBJECT_TYPE_FIELD, "keyword");
            builder.endObject();
            builder.startObject(OBJECT_TYPE_FIELD);
            builder.field(OBJECT_TYPE_FIELD, "keyword");
            builder.endObject();
            builder.endObject();
            builder.endObject();
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to build mappings for .synonyms-2", e);
        }
    }

    public void getSynonymsSets(final int from, final int size, final ActionListener<PagedResult<SynonymSetSummary>> listener) {
        this.client.prepareSearch(SYNONYMS_ALIAS_NAME).setSize(0).setQuery(QueryBuilders.termQuery(OBJECT_TYPE_FIELD, SYNONYM_RULE_OBJECT_TYPE)).addAggregation(((TermsAggregationBuilder)new TermsAggregationBuilder(SYNONYM_SETS_AGG_NAME).field(SYNONYMS_SET_FIELD)).order(BucketOrder.key(true)).size(10000)).setPreference(Preference.LOCAL.type()).execute(new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                Terms termsAggregation = (Terms)searchResponse.getAggregations().get(SynonymsManagementAPIService.SYNONYM_SETS_AGG_NAME);
                List<? extends Terms.Bucket> buckets = termsAggregation.getBuckets();
                Writeable[] synonymSetSummaries = (SynonymSetSummary[])buckets.stream().skip(from).limit(size).map((? super T bucket) -> new SynonymSetSummary(bucket.getDocCount(), bucket.getKeyAsString())).toArray(SynonymSetSummary[]::new);
                listener.onResponse(new PagedResult((long)buckets.size(), synonymSetSummaries));
            }

            @Override
            public void onFailure(Exception e) {
                Throwable cause = ExceptionsHelper.unwrapCause(e);
                if (cause instanceof IndexNotFoundException) {
                    listener.onResponse(new PagedResult(0L, (Writeable[])new SynonymSetSummary[0]));
                    return;
                }
                listener.onFailure(e);
            }
        });
    }

    public void getSynonymSetRules(String synonymSetId, int from, int size, ActionListener<PagedResult<SynonymRule>> listener) {
        this.client.prepareSearch(SYNONYMS_ALIAS_NAME).setQuery(QueryBuilders.boolQuery().must(QueryBuilders.termQuery(SYNONYMS_SET_FIELD, synonymSetId)).filter(QueryBuilders.termQuery(OBJECT_TYPE_FIELD, SYNONYM_RULE_OBJECT_TYPE))).setFrom(from).setSize(size).addSort("id", SortOrder.ASC).setPreference(Preference.LOCAL.type()).setTrackTotalHits(true).execute(new DelegatingIndexNotFoundActionListener<SearchResponse, PagedResult<SynonymRule>>(synonymSetId, listener, (searchListener, searchResponse) -> {
            long totalSynonymRules = searchResponse.getHits().getTotalHits().value;
            if (totalSynonymRules == 0L) {
                this.checkSynonymSetExists(synonymSetId, searchListener.delegateFailure((existsListener, response) -> searchListener.onResponse(new PagedResult(0L, (Writeable[])new SynonymRule[0]))));
                return;
            }
            Writeable[] synonymRules = (SynonymRule[])Arrays.stream(searchResponse.getHits().getHits()).map(hit -> SynonymsManagementAPIService.sourceMapToSynonymRule(hit.getSourceAsMap())).toArray(SynonymRule[]::new);
            searchListener.onResponse(new PagedResult(totalSynonymRules, synonymRules));
        }));
    }

    private static SynonymRule sourceMapToSynonymRule(Map<String, Object> docSourceAsMap) {
        return new SynonymRule((String)docSourceAsMap.get(SYNONYM_RULE_ID_FIELD), (String)docSourceAsMap.get(SYNONYMS_FIELD));
    }

    private static void logUniqueFailureMessagesWithIndices(List<BulkItemResponse.Failure> bulkFailures) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        Map<String, List<BulkItemResponse.Failure>> uniqueFailureMessages = bulkFailures.stream().collect(Collectors.groupingBy(BulkItemResponse.Failure::getMessage));
        uniqueFailureMessages.forEach((failureMessage, failures) -> logger.debug("Error updating synonyms: [{}], indices: [{}], stacktrace: [{}]", failureMessage, (Object)failures.stream().map(BulkItemResponse.Failure::getIndex).collect(Collectors.joining(",")), (Object)ExceptionsHelper.formatStackTrace(((BulkItemResponse.Failure)failures.get(0)).getCause().getStackTrace())));
    }

    public void putSynonymsSet(String synonymSetId, SynonymRule[] synonymsSet, ActionListener<SynonymsReloadResult> listener) {
        this.deleteSynonymsSetObjects(synonymSetId, listener.delegateFailure((deleteByQueryResponseListener, bulkDeleteResponse) -> {
            boolean created = bulkDeleteResponse.getDeleted() == 0L;
            List<BulkItemResponse.Failure> bulkDeleteFailures = bulkDeleteResponse.getBulkFailures();
            if (!bulkDeleteFailures.isEmpty()) {
                SynonymsManagementAPIService.logUniqueFailureMessagesWithIndices(bulkDeleteFailures);
                listener.onFailure(new ElasticsearchException("Error updating synonyms: " + bulkDeleteFailures.stream().map(BulkItemResponse.Failure::getMessage).collect(Collectors.joining("\n")), new Object[0]));
                return;
            }
            BulkRequestBuilder bulkRequestBuilder = this.client.prepareBulk();
            try {
                bulkRequestBuilder.add(SynonymsManagementAPIService.createSynonymSetIndexRequest(synonymSetId));
                for (SynonymRule synonymRule : synonymsSet) {
                    bulkRequestBuilder.add(SynonymsManagementAPIService.createSynonymRuleIndexRequest(synonymSetId, synonymRule));
                }
            }
            catch (IOException ex) {
                listener.onFailure(ex);
            }
            bulkRequestBuilder.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute(deleteByQueryResponseListener.delegateFailure((bulkInsertResponseListener, bulkInsertResponse) -> {
                if (bulkInsertResponse.hasFailures()) {
                    SynonymsManagementAPIService.logUniqueFailureMessagesWithIndices(Arrays.stream(bulkInsertResponse.getItems()).filter(BulkItemResponse::isFailed).map(BulkItemResponse::getFailure).collect(Collectors.toList()));
                    bulkInsertResponseListener.onFailure(new ElasticsearchException("Error updating synonyms: " + bulkInsertResponse.buildFailureMessage(), new Object[0]));
                    return;
                }
                UpdateSynonymsResultStatus updateSynonymsResultStatus = created ? UpdateSynonymsResultStatus.CREATED : UpdateSynonymsResultStatus.UPDATED;
                this.reloadAnalyzers(synonymSetId, false, (ActionListener<SynonymsReloadResult>)bulkInsertResponseListener, updateSynonymsResultStatus);
            }));
        }));
    }

    public void putSynonymRule(String synonymsSetId, SynonymRule synonymRule, ActionListener<SynonymsReloadResult> listener) {
        this.checkSynonymSetExists(synonymsSetId, listener.delegateFailure((l1, obj) -> {
            try {
                IndexRequest indexRequest = (IndexRequest)SynonymsManagementAPIService.createSynonymRuleIndexRequest(synonymsSetId, synonymRule).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
                this.client.index(indexRequest, l1.delegateFailure((l2, indexResponse) -> {
                    UpdateSynonymsResultStatus updateStatus = indexResponse.status() == RestStatus.CREATED ? UpdateSynonymsResultStatus.CREATED : UpdateSynonymsResultStatus.UPDATED;
                    this.reloadAnalyzers(synonymsSetId, false, (ActionListener<SynonymsReloadResult>)l2, updateStatus);
                }));
            }
            catch (IOException e) {
                l1.onFailure(e);
            }
        }));
    }

    public void getSynonymRule(String synonymSetId, String synonymRuleId, ActionListener<SynonymRule> listener) {
        this.checkSynonymSetExists(synonymSetId, listener.delegateFailure((l1, obj) -> this.client.prepareGet(SYNONYMS_ALIAS_NAME, SynonymsManagementAPIService.internalSynonymRuleId(synonymSetId, synonymRuleId)).execute(l1.delegateFailure((l2, getResponse) -> {
            if (!getResponse.isExists()) {
                l2.onFailure(new ResourceNotFoundException("synonym rule [" + synonymRuleId + "] not found", new Object[0]));
                return;
            }
            l2.onResponse(SynonymsManagementAPIService.sourceMapToSynonymRule(getResponse.getSourceAsMap()));
        }))));
    }

    public void deleteSynonymRule(String synonymsSetId, String synonymRuleId, ActionListener<SynonymsReloadResult> listener) {
        this.client.prepareDelete(SYNONYMS_ALIAS_NAME, SynonymsManagementAPIService.internalSynonymRuleId(synonymsSetId, synonymRuleId)).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE).execute(new DelegatingIndexNotFoundActionListener<DeleteResponse, SynonymsReloadResult>(synonymsSetId, listener, (l, deleteResponse) -> {
            if (deleteResponse.getResult() == DocWriteResponse.Result.NOT_FOUND) {
                this.checkSynonymSetExists(synonymsSetId, l.delegateFailure((checkListener, obj) -> checkListener.onFailure(new ResourceNotFoundException("synonym rule [" + synonymRuleId + "] not found on synonyms set [" + synonymsSetId + "]", new Object[0]))));
                return;
            }
            this.reloadAnalyzers(synonymsSetId, false, listener, UpdateSynonymsResultStatus.DELETED);
        }));
    }

    private static IndexRequest createSynonymRuleIndexRequest(String synonymsSetId, SynonymRule synonymRule) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field(SYNONYMS_SET_FIELD, synonymsSetId);
            builder.field(SYNONYM_RULE_ID_FIELD, synonymRule.id());
            builder.field(SYNONYMS_FIELD, synonymRule.synonyms());
            builder.field(OBJECT_TYPE_FIELD, SYNONYM_RULE_OBJECT_TYPE);
            builder.endObject();
            IndexRequest indexRequest = new IndexRequest(SYNONYMS_ALIAS_NAME).id(SynonymsManagementAPIService.internalSynonymRuleId(synonymsSetId, synonymRule.id())).opType(DocWriteRequest.OpType.INDEX).source(builder);
            return indexRequest;
        }
    }

    private static IndexRequest createSynonymSetIndexRequest(String synonymsSetId) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.field(SYNONYMS_SET_FIELD, synonymsSetId);
            builder.field(OBJECT_TYPE_FIELD, SYNONYM_SET_OBJECT_TYPE);
            builder.endObject();
            IndexRequest indexRequest = new IndexRequest(SYNONYMS_ALIAS_NAME).id(synonymsSetId).opType(DocWriteRequest.OpType.INDEX).source(builder);
            return indexRequest;
        }
    }

    private <T> void checkSynonymSetExists(String synonymsSetId, ActionListener<T> listener) {
        this.client.prepareGet(SYNONYMS_ALIAS_NAME, synonymsSetId).execute(new DelegatingIndexNotFoundActionListener<GetResponse, T>(synonymsSetId, listener, (l, getResponse) -> {
            if (!getResponse.isExists()) {
                l.onFailure(new ResourceNotFoundException("synonyms set [" + synonymsSetId + "] not found", new Object[0]));
                return;
            }
            l.onResponse(null);
        }));
    }

    private void deleteSynonymsSetObjects(String synonymSetId, ActionListener<BulkByScrollResponse> listener) {
        DeleteByQueryRequest dbqRequest = ((DeleteByQueryRequest)new DeleteByQueryRequest(SYNONYMS_ALIAS_NAME).setQuery(QueryBuilders.termQuery(SYNONYMS_SET_FIELD, synonymSetId)).setRefresh(true)).setIndicesOptions(IndicesOptions.fromOptions(true, true, false, false));
        this.client.execute(DeleteByQueryAction.INSTANCE, dbqRequest, listener);
    }

    public void deleteSynonymsSet(String synonymSetId, ActionListener<AcknowledgedResponse> listener) {
        this.reloadAnalyzers(synonymSetId, true, listener.delegateFailure((reloadListener, reloadResult) -> {
            Map<String, ReloadAnalyzersResponse.ReloadDetails> reloadDetails = reloadResult.reloadAnalyzersResponse.getReloadDetails();
            if (!reloadDetails.isEmpty()) {
                Set indices = reloadDetails.entrySet().stream().map(entry -> ((ReloadAnalyzersResponse.ReloadDetails)entry.getValue()).getIndexName()).collect(Collectors.toSet());
                reloadListener.onFailure(new IllegalArgumentException("synonyms set [" + synonymSetId + "] cannot be deleted as it is used in the following indices: " + String.join((CharSequence)", ", indices)));
                return;
            }
            this.deleteSynonymsSetObjects(synonymSetId, listener.delegateFailure((deleteObjectsListener, bulkByScrollResponse) -> {
                if (bulkByScrollResponse.getDeleted() == 0L) {
                    deleteObjectsListener.onFailure(new ResourceNotFoundException("synonyms set [" + synonymSetId + "] not found", new Object[0]));
                    return;
                }
                List<BulkItemResponse.Failure> bulkFailures = bulkByScrollResponse.getBulkFailures();
                if (!bulkFailures.isEmpty()) {
                    deleteObjectsListener.onFailure(new InvalidParameterException("Error deleting synonyms set: " + bulkFailures.stream().map(BulkItemResponse.Failure::getMessage).collect(Collectors.joining("\n"))));
                    return;
                }
                deleteObjectsListener.onResponse(AcknowledgedResponse.of(true));
            }));
        }), null);
    }

    private <T> void reloadAnalyzers(String synonymSetId, boolean preview, ActionListener<SynonymsReloadResult> listener, UpdateSynonymsResultStatus synonymsOperationResult) {
        ReloadAnalyzersRequest reloadAnalyzersRequest = new ReloadAnalyzersRequest(synonymSetId, preview, "*");
        this.client.execute(TransportReloadAnalyzersAction.TYPE, reloadAnalyzersRequest, listener.safeMap(reloadResponse -> new SynonymsReloadResult(synonymsOperationResult, (ReloadAnalyzersResponse)reloadResponse)));
    }

    private static String internalSynonymRuleId(String synonymsSetId, String synonymRuleId) {
        return synonymsSetId + SYNONYM_RULE_ID_SEPARATOR + synonymRuleId;
    }

    static Settings settings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("index.auto_expand_replicas", "0-all").put(IndexMetadata.INDEX_FORMAT_SETTING.getKey(), 2).build();
    }

    static class DelegatingIndexNotFoundActionListener<T, R>
    extends DelegatingActionListener<T, R> {
        private final BiConsumer<ActionListener<R>, T> bc;
        private final String synonymSetId;

        DelegatingIndexNotFoundActionListener(String synonymSetId, ActionListener<R> delegate, BiConsumer<ActionListener<R>, T> bc) {
            super(delegate);
            this.bc = bc;
            this.synonymSetId = synonymSetId;
        }

        @Override
        public void onResponse(T t) {
            this.bc.accept(this.delegate, (ActionListener)t);
        }

        @Override
        public void onFailure(Exception e) {
            Throwable cause = ExceptionsHelper.unwrapCause(e);
            if (cause instanceof IndexNotFoundException) {
                this.delegate.onFailure(new ResourceNotFoundException("synonyms set [" + this.synonymSetId + "] not found", new Object[0]));
                return;
            }
            this.delegate.onFailure(e);
        }
    }

    public static enum UpdateSynonymsResultStatus {
        CREATED,
        UPDATED,
        DELETED;

    }

    public record SynonymsReloadResult(UpdateSynonymsResultStatus synonymsOperationResult, ReloadAnalyzersResponse reloadAnalyzersResponse) {
    }
}

