/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class MinAggregator
extends NumericMetricsAggregator.SingleValue {
    private static final int MAX_BKD_LOOKUPS = 1024;
    final ValuesSource.Numeric valuesSource;
    final DocValueFormat format;
    final String pointField;
    final Function<byte[], Number> pointConverter;
    DoubleArray mins;

    MinAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
        this.mins = context.bigArrays().newDoubleArray(1L, false);
        this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
        this.format = config.format();
        this.pointConverter = this.pointReaderIfAvailable(config);
        this.pointField = this.pointConverter != null ? config.fieldContext().field() : null;
    }

    @Override
    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    @Override
    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        Number segMin;
        if (this.pointConverter != null && (segMin = MinAggregator.findLeafMinValue(aggCtx.getLeafReaderContext().reader(), this.pointField, this.pointConverter)) != null) {
            double min = this.mins.get(0L);
            min = Math.min(min, segMin.doubleValue());
            this.mins.set(0L, min);
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        SortedNumericDoubleValues allValues = this.valuesSource.doubleValues(aggCtx.getLeafReaderContext());
        final NumericDoubleValues values = MultiValueMode.MIN.select(allValues);
        return new LeafBucketCollectorBase(sub, allValues){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                if (bucket >= MinAggregator.this.mins.size()) {
                    long from = MinAggregator.this.mins.size();
                    MinAggregator.this.mins = MinAggregator.this.bigArrays().grow(MinAggregator.this.mins, bucket + 1L);
                    MinAggregator.this.mins.fill(from, MinAggregator.this.mins.size(), Double.POSITIVE_INFINITY);
                }
                if (values.advanceExact(doc)) {
                    double value = values.doubleValue();
                    double min = MinAggregator.this.mins.get(bucket);
                    min = Math.min(min, value);
                    MinAggregator.this.mins.set(bucket, min);
                }
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        if (owningBucketOrd >= this.mins.size()) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mins.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (bucket >= this.mins.size()) {
            return this.buildEmptyAggregation();
        }
        return new Min(this.name, this.mins.get(bucket), this.format, this.metadata());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return Min.createEmptyMin(this.name, this.format, this.metadata());
    }

    @Override
    public void doClose() {
        Releasables.close((Releasable)this.mins);
    }

    static Number findLeafMinValue(LeafReader reader, String fieldName, final Function<byte[], Number> converter) throws IOException {
        PointValues pointValues = reader.getPointValues(fieldName);
        if (pointValues == null) {
            return null;
        }
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return converter.apply(pointValues.getMinPackedValue());
        }
        final Number[] result = new Number[1];
        try {
            pointValues.intersect(new PointValues.IntersectVisitor(){
                private short lookupCounter = 0;

                public void visit(int docID) {
                    throw new UnsupportedOperationException();
                }

                public void visit(int docID, byte[] packedValue) {
                    if (liveDocs.get(docID)) {
                        result[0] = (Number)converter.apply(packedValue);
                        throw new CollectionTerminatedException();
                    }
                    this.lookupCounter = (short)(this.lookupCounter + 1);
                    if (this.lookupCounter > 1024) {
                        throw new CollectionTerminatedException();
                    }
                }

                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
            });
        }
        catch (CollectionTerminatedException collectionTerminatedException) {
            // empty catch block
        }
        return result[0];
    }
}

