/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevenshteinDistance;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;

public abstract class BaseRestHandler
implements RestHandler {
    public static final String INCLUDE_TYPE_NAME_PARAMETER = "include_type_name";
    public static final boolean DEFAULT_INCLUDE_TYPE_NAME_POLICY = false;
    public static final Setting<Boolean> MULTI_ALLOW_EXPLICIT_INDEX = Setting.boolSetting("rest.action.multi.allow_explicit_index", true, Setting.Property.NodeScope);
    private final LongAdder usageCount = new LongAdder();

    public final long getUsageCount() {
        return this.usageCount.sum();
    }

    public abstract String getName();

    @Override
    public abstract List<RestHandler.Route> routes();

    @Override
    public final void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        try (RestChannelConsumer action = this.prepareRequest(request, client);){
            SortedSet unconsumedParams = request.unconsumedParams().stream().filter(p -> !this.responseParams(request.getRestApiVersion()).contains(p)).collect(Collectors.toCollection(TreeSet::new));
            if (!unconsumedParams.isEmpty()) {
                HashSet<String> candidateParams = new HashSet<String>();
                candidateParams.addAll(request.consumedParams());
                candidateParams.addAll(this.responseParams(request.getRestApiVersion()));
                throw new IllegalArgumentException(BaseRestHandler.unrecognized(request, unconsumedParams, candidateParams, "parameter"));
            }
            if (request.hasContent() && !request.isContentConsumed()) {
                throw new IllegalArgumentException("request [" + request.method() + " " + request.path() + "] does not support having a body");
            }
            this.usageCount.increment();
            action.accept(channel);
        }
    }

    protected static String unrecognized(RestRequest request, Set<String> invalids, Set<String> candidates, String detail) {
        StringBuilder message = new StringBuilder().append("request [").append(request.path()).append("] contains unrecognized ").append(detail).append(invalids.size() > 1 ? "s" : "").append(": ");
        Iterator<String> it = invalids.iterator();
        while (it.hasNext()) {
            String invalid = it.next();
            LevenshteinDistance ld = new LevenshteinDistance();
            List<String> candidateParams = candidates.stream().map(c -> Tuple.tuple((Object)Float.valueOf(ld.getDistance(invalid, c)), (Object)c)).filter(t -> ((Float)t.v1()).floatValue() > 0.5f).sorted(Comparator.comparing(Tuple::v1).reversed().thenComparing(Tuple::v2)).map(Tuple::v2).toList();
            message.append("[").append(invalid).append("]");
            if (!candidateParams.isEmpty()) {
                message.append(" -> did you mean ");
                if (candidateParams.size() > 1) {
                    message.append("any of ");
                }
                message.append(candidateParams);
                message.append("?");
            }
            if (!it.hasNext()) continue;
            message.append(", ");
        }
        return message.toString();
    }

    protected abstract RestChannelConsumer prepareRequest(RestRequest var1, NodeClient var2) throws IOException;

    protected Set<String> responseParams() {
        return Collections.emptySet();
    }

    protected Set<String> responseParams(RestApiVersion restApiVersion) {
        return this.responseParams();
    }

    @FunctionalInterface
    protected static interface RestChannelConsumer
    extends CheckedConsumer<RestChannel, Exception>,
    Releasable {
        default public void close() {
        }
    }
}

