/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.spatial;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.geo.LuceneGeometriesUtils;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.mapper.ShapeIndexer;

public class CartesianShapeIndexer
implements ShapeIndexer {
    private final String name;

    public CartesianShapeIndexer(String name) {
        this.name = name;
    }

    @Override
    public List<IndexableField> indexShape(Geometry shape) {
        if (shape == null) {
            return Collections.emptyList();
        }
        LuceneGeometryVisitor visitor = new LuceneGeometryVisitor(this.name);
        shape.visit((GeometryVisitor)visitor);
        return visitor.fields;
    }

    private static XYPolygon toLuceneXYPolygon(Rectangle r) {
        return new XYPolygon(new float[]{(float)r.getMinX(), (float)r.getMaxX(), (float)r.getMaxX(), (float)r.getMinX(), (float)r.getMinX()}, new float[]{(float)r.getMinY(), (float)r.getMinY(), (float)r.getMaxY(), (float)r.getMaxY(), (float)r.getMinY()}, new XYPolygon[0]);
    }

    private static class LuceneGeometryVisitor
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private String name;

        private LuceneGeometryVisitor(String name) {
            this.name = name;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYLine)LuceneGeometriesUtils.toXYLine(line)));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (float)((float)point.getX()), (float)((float)point.getY())));
            return null;
        }

        public Void visit(Polygon polygon) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)LuceneGeometriesUtils.toXYPolygon(polygon), (boolean)true));
            return null;
        }

        public Void visit(Rectangle r) {
            this.addFields((IndexableField[])XYShape.createIndexableFields((String)this.name, (XYPolygon)CartesianShapeIndexer.toLuceneXYPolygon(r)));
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

