/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.wfsfeatures;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.FactoryConfigurationError;
import jeeves.server.context.ServiceContext;
import jeeves.xlink.Processor;
import org.apache.commons.io.FileUtils;
import org.apache.jcs.access.exception.CacheException;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.exceptions.BadXmlResponseEx;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.fragment.FragmentHarvester;
import org.fao.geonet.kernel.harvest.harvester.wfsfeatures.WfsFeaturesParams;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlElementReader;
import org.fao.geonet.utils.XmlRequest;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

class Harvester
implements IHarvester<HarvestResult> {
    private final AtomicBoolean cancelMonitor;
    private Logger log;
    private ServiceContext context;
    private WfsFeaturesParams params;
    private IMetadataManager metadataManager;
    private SchemaManager schemaMan;
    private HarvestResult result;
    private UUIDMapper localUuids;
    private String metadataGetService;
    private Path stylesheetDirectory;
    private Map<String, Object> ssParams = new HashMap<String, Object>();
    private List<HarvestError> errors;

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, WfsFeaturesParams params, List<HarvestError> errors) {
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.context = context;
        this.params = params;
        this.errors = errors;
        this.result = new HarvestResult();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.schemaMan = (SchemaManager)gc.getBean(SchemaManager.class);
        SettingInfo si = (SettingInfo)context.getBean(SettingInfo.class);
        String siteUrl = si.getSiteUrl() + context.getBaseUrl();
        this.metadataGetService = "local://" + context.getNodeId() + "/api/records/";
        this.ssParams.put("siteUrl", siteUrl);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        log.info("Retrieving metadata fragments for : " + this.params.getName());
        IMetadataUtils metadataRepository = (IMetadataUtils)this.context.getBean(IMetadataUtils.class);
        this.localUuids = new UUIDMapper(metadataRepository, this.params.getUuid());
        Element wfsQuery = null;
        log.info("Parsing query :\n" + this.params.query);
        try {
            wfsQuery = Xml.loadString((String)this.params.query, (boolean)false);
        }
        catch (JDOMException e) {
            this.errors.add(new HarvestError(this.context, e));
            throw new BadParameterEx("GetFeature Query failed to parse\n", (Object)this.params.query);
        }
        FragmentHarvester fragmentHarvester = new FragmentHarvester(this.cancelMonitor, log, this.context, this.getFragmentHarvesterParams());
        if (this.params.streamFeatures) {
            this.harvestFeatures(wfsQuery, fragmentHarvester);
        } else {
            this.harvestResponse(wfsQuery, fragmentHarvester);
        }
        return this.result;
    }

    private void harvestResponse(Element xmlQuery, FragmentHarvester fragmentHarvester) throws IOException, JDOMException, MalformedURLException, BadXmlResponseEx, Exception {
        Element xml = Xml.loadFile((URL)new URL(this.params.url), (Element)xmlQuery);
        if (xml == null) {
            throw new BadXmlResponseEx("No response or problem getting response from " + this.params.url + ":\n" + Xml.getString((Element)xmlQuery));
        }
        this.stylesheetDirectory = this.schemaMan.getSchemaDir(this.params.outputSchema).resolve("convert/WFSToFragments");
        if (!this.params.stylesheet.trim().equals("")) {
            xml = Xml.transform((Element)xml, (Path)this.stylesheetDirectory.resolve(this.params.stylesheet), this.ssParams);
        }
        this.log.info("Applying " + this.stylesheetDirectory + "/" + this.params.stylesheet);
        this.harvest(xml, fragmentHarvester);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void harvestFeatures(Element xmlQuery, FragmentHarvester fragmentHarvester) throws FactoryConfigurationError, Exception {
        XmlRequest req = ((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class)).createXmlRequest(this.params.url);
        req.setRequest(xmlQuery);
        Lib.net.setupProxy(this.context, req);
        Path tempFile = Files.createTempFile("temp-", ".xml", new FileAttribute[0]);
        try {
            XmlElementReader reader;
            req.executeLarge(tempFile);
            ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
            namespaces.add(Namespace.getNamespace((String)"gml", (String)"http://www.opengis.net/gml"));
            try (InputStream fin = IO.newInputStream((Path)tempFile);){
                reader = new XmlElementReader(fin, "gml:featureMembers/*", namespaces);
            }
            if (this.cancelMonitor.get()) {
                return;
            }
            if (!reader.hasNext()) {
                namespaces.add(Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs"));
                fin = IO.newInputStream((Path)tempFile);
                try {
                    reader = new XmlElementReader(fin, "wfs:FeatureCollection/gml:featureMember", namespaces);
                }
                finally {
                    if (fin != null) {
                        fin.close();
                    }
                }
            }
            while (reader.hasNext()) {
                if (this.cancelMonitor.get()) {
                    return;
                }
                this.stylesheetDirectory = this.schemaMan.getSchemaDir(this.params.outputSchema).resolve("convert/WFSToFragments");
                Element records = Xml.transform((Element)reader.next(), (Path)this.stylesheetDirectory.resolve(this.params.stylesheet), this.ssParams);
                this.harvest(records, fragmentHarvester);
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile.toFile());
        }
    }

    private void harvest(Element xml, FragmentHarvester fragmentHarvester) throws Exception {
        FragmentHarvester.HarvestSummary fragmentResult = fragmentHarvester.harvest(xml, this.params.url);
        this.deleteOrphanedMetadata(fragmentResult.updatedMetadata);
        this.result.fragmentsReturned += fragmentResult.fragmentsReturned;
        this.result.fragmentsUnknownSchema += fragmentResult.fragmentsUnknownSchema;
        this.result.subtemplatesAdded += fragmentResult.fragmentsAdded;
        this.result.fragmentsMatched += fragmentResult.fragmentsMatched;
        this.result.recordsBuilt += fragmentResult.recordsBuilt;
        this.result.recordsUpdated += fragmentResult.recordsUpdated;
        this.result.subtemplatesUpdated += fragmentResult.fragmentsUpdated;
        this.result.totalMetadata = this.result.subtemplatesAdded + this.result.addedMetadata;
        this.result.originalMetadata = this.result.fragmentsReturned;
    }

    public void deleteOrphanedMetadata(Set<String> updatedMetadata) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Removing orphaned metadata records and fragments after update");
        }
        for (String uuid : this.localUuids.getUUIDs()) {
            HarvestError error;
            try {
                String isTemplate = this.localUuids.getTemplate(uuid);
                if (isTemplate.equals("s")) {
                    Processor.uncacheXLinkUri((String)(this.metadataGetService + uuid));
                }
                if (updatedMetadata.contains(uuid)) continue;
                String id = this.localUuids.getID(uuid);
                this.metadataManager.deleteMetadata(this.context, id);
                if (isTemplate.equals("s")) {
                    ++this.result.subtemplatesRemoved;
                    continue;
                }
                ++this.result.locallyRemoved;
            }
            catch (CacheException e) {
                error = new HarvestError(this.context, e);
                this.errors.add(error);
            }
            catch (Exception e) {
                error = new HarvestError(this.context, e);
                this.errors.add(error);
            }
        }
        if (this.result.subtemplatesRemoved + this.result.locallyRemoved > 0) {
            this.metadataManager.flush();
        }
    }

    private FragmentHarvester.FragmentParams getFragmentHarvesterParams() {
        FragmentHarvester.FragmentParams fragmentParams = new FragmentHarvester.FragmentParams();
        fragmentParams.categories = this.params.getCategories();
        fragmentParams.createSubtemplates = this.params.createSubtemplates;
        fragmentParams.outputSchema = this.params.outputSchema;
        fragmentParams.isoCategory = this.params.recordsCategory;
        fragmentParams.privileges = this.params.getPrivileges();
        fragmentParams.templateId = this.params.templateId;
        fragmentParams.uuid = this.params.getUuid();
        fragmentParams.owner = this.params.getOwnerId();
        return fragmentParams;
    }
}

