/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.database;

import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseMetadataRetriever;
import org.fao.geonet.kernel.harvest.harvester.database.DatabaseMetadataRetrieverException;

class DatabaseMetadataRetrieverFactory {
    private DatabaseMetadataRetrieverFactory() {
    }

    public static DatabaseMetadataRetriever getDatabaseMetadataRetriever(String dbType, String server, int port, String database, String username, String password, Logger log) throws DatabaseMetadataRetrieverException {
        DatabaseMetadataRetriever metadataRetriever;
        if (dbType.equalsIgnoreCase("postgresql")) {
            String connectionString = "jdbc:postgresql://" + server + ":" + port + "/" + database;
            String driverName = "org.postgresql.Driver";
            metadataRetriever = new DatabaseMetadataRetriever(driverName, connectionString, username, password, log);
        } else if (dbType.equalsIgnoreCase("oracle")) {
            String connectionString = String.format("jdbc:oracle:thin:@%s:%d:%s", server, port, database);
            String driverName = "oracle.jdbc.driver.OracleDriver";
            metadataRetriever = new DatabaseMetadataRetriever(driverName, connectionString, username, password, log);
        } else {
            throw new DatabaseMetadataRetrieverException("Connection for database type " + dbType + " not supported");
        }
        return metadataRetriever;
    }
}

