/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.database;

import org.springframework.util.StringUtils;

public class DatabaseHarvesterUtil {
    private static final String REGEX_NAME_PREFIX_INVALID_CHARS = "^[^_a-zA-Z]+";
    private static final String REGEX_NAME_INVALID_CHARS = "[^_a-zA-Z0-9]";

    private DatabaseHarvesterUtil() {
    }

    static String sanitizeFieldName(String fieldName) {
        return DatabaseHarvesterUtil.sanitizeValue(fieldName);
    }

    static String sanitizeTableName(String tableName) {
        if (StringUtils.hasLength((String)tableName)) {
            String[] parts = tableName.split("\\.", -1);
            if (parts.length == 2) {
                String schema = DatabaseHarvesterUtil.sanitizeValue(parts[0]);
                String table = DatabaseHarvesterUtil.sanitizeValue(parts[1]);
                return schema + "." + table;
            }
            return DatabaseHarvesterUtil.sanitizeValue(tableName);
        }
        return "";
    }

    static String sanitizeValue(String value) {
        if (StringUtils.hasLength((String)value)) {
            return value.replaceAll(REGEX_NAME_PREFIX_INVALID_CHARS, "").replaceAll(REGEX_NAME_INVALID_CHARS, "");
        }
        return "";
    }
}

