/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thesaurus;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.KeywordBean;
import org.fao.geonet.kernel.Thesaurus;
import org.fao.geonet.kernel.ThesaurusManager;
import org.fao.geonet.services.thesaurus.AddElement;
import org.jdom.Content;
import org.jdom.Element;

public class UpdateElement
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        String ref = Util.getParam((Element)params, (String)"ref");
        String oldid = Util.getParam((Element)params, (String)"oldid");
        String newid = Util.getParam((Element)params, (String)"newid");
        String namespace = Util.getParam((Element)params, (String)"namespace");
        String thesaType = Util.getParam((Element)params, (String)"refType");
        ThesaurusManager manager = (ThesaurusManager)gc.getBean(ThesaurusManager.class);
        Thesaurus thesaurus = manager.getThesaurusByName(ref);
        if (!oldid.equals(newid)) {
            if (thesaurus.isFreeCode(null, newid)) {
                thesaurus.updateCodeByURI(oldid, newid);
            } else {
                Element elResp = new Element("response");
                elResp.addContent((Content)new Element("error").addContent((Content)new Element("message").setText("Code value already exists in thesaurus")));
                return elResp;
            }
        }
        KeywordBean bean = new KeywordBean(thesaurus.getIsoLanguageMapper()).setNamespaceCode(namespace).setUriCode(newid);
        Map<Pair<String, String>, String> localizations = AddElement.getLocalizedElements(params);
        if (localizations.isEmpty()) {
            String prefLab = Util.getParam((Element)params, (String)"label");
            String lang = Util.getParam((Element)params, (String)"lang");
            String definition = Util.getParam((Element)params, (String)"definition", (String)"");
            bean.setValue(prefLab, lang).setDefinition(definition, lang);
        } else {
            Set<Map.Entry<Pair<String, String>, String>> entries = localizations.entrySet();
            for (Map.Entry<Pair<String, String>, String> entry : entries) {
                String lang = (String)entry.getKey().one();
                if (((String)entry.getKey().two()).equals("definition")) {
                    String definition = entry.getValue();
                    bean.setDefinition(definition, lang);
                    continue;
                }
                if (((String)entry.getKey().two()).equals("label")) {
                    String label = entry.getValue();
                    bean.setValue(label, lang);
                    continue;
                }
                throw new IllegalArgumentException("Unknown localization type: " + (String)entry.getKey().two());
            }
        }
        if (thesaType.equals("place")) {
            bean.setCoordEast(Util.getParam((Element)params, (String)"east")).setCoordNorth(Util.getParam((Element)params, (String)"north")).setCoordSouth(Util.getParam((Element)params, (String)"south")).setCoordWest(Util.getParam((Element)params, (String)"west"));
        }
        thesaurus.updateElement(bean, false);
        Element elResp = new Element("response");
        elResp.addContent((Content)new Element("selected").setText(ref));
        elResp.addContent((Content)new Element("mode").setText("edit"));
        return elResp;
    }
}

