/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.Filters;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.xml.sax.helpers.NamespaceSupport;

public class AttributeExpressionImpl
extends DefaultExpression
implements PropertyName {
    private static final Logger LOGGER = Logging.getLogger(AttributeExpressionImpl.class);
    protected String attPath;
    protected SimpleFeatureType schema = null;
    public NamespaceSupport namespaceSupport;
    protected boolean lenient = true;
    private Hints hints;
    private volatile PropertyAccessor lastAccessor;

    protected AttributeExpressionImpl(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public AttributeExpressionImpl(String xpath) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = null;
        this.hints = null;
    }

    public AttributeExpressionImpl(Name name) {
        this.attPath = name.getLocalPart();
        this.schema = null;
        if (name.getNamespaceURI() != null) {
            this.namespaceSupport = new NamespaceSupport();
            this.namespaceSupport.declarePrefix("", name.getNamespaceURI());
        } else {
            this.namespaceSupport = null;
        }
    }

    public AttributeExpressionImpl(String xpath, NamespaceSupport namespaceContext) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = namespaceContext;
    }

    public AttributeExpressionImpl(String xpath, Hints hints) {
        this.attPath = xpath;
        this.schema = null;
        this.namespaceSupport = null;
        this.hints = hints;
    }

    public NamespaceSupport getNamespaceContext() {
        return this.namespaceSupport;
    }

    protected AttributeExpressionImpl(SimpleFeatureType schema, String attPath) throws IllegalFilterException {
        this.schema = schema;
        this.setPropertyName(attPath);
    }

    public String getPropertyName() {
        return this.attPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPropertyName(String attPath) {
        LOGGER.entering("ExpressionAttribute", "setAttributePath", attPath);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("schema: " + this.schema + "\n\nattribute: " + attPath);
        }
        if (this.schema != null) {
            if (this.schema.getDescriptor(attPath) == null) throw new IllegalFilterException("Attribute: " + attPath + " is not in stated schema " + this.schema.getTypeName() + ".");
            this.attPath = attPath;
            return;
        } else {
            this.attPath = attPath;
        }
    }

    @Override
    public Object evaluate(Object obj) {
        return this.evaluate(obj, null);
    }

    @Override
    public <T> T evaluate(Object obj, Class<T> target) {
        PropertyAccessor accessor = this.lastAccessor;
        Boolean value = false;
        boolean success = false;
        if (accessor != null && accessor.canHandle(obj, this.attPath, target)) {
            try {
                value = accessor.get(obj, this.attPath, target);
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!success) {
            if (this.namespaceSupport != null && this.hints == null) {
                this.hints = new Hints((RenderingHints.Key)PropertyAccessorFactory.NAMESPACE_CONTEXT, (Object)this.namespaceSupport);
            }
            List<PropertyAccessor> accessors = PropertyAccessors.findPropertyAccessors(obj, this.attPath, target, this.hints);
            ArrayList<Exception> exceptions = null;
            if (accessors != null) {
                Iterator<PropertyAccessor> iterator = accessors.iterator();
                while (iterator.hasNext()) {
                    PropertyAccessor propertyAccessor;
                    accessor = propertyAccessor = iterator.next();
                    try {
                        value = accessor.get(obj, this.attPath, target);
                        success = true;
                        break;
                    }
                    catch (Exception e2) {
                        if (exceptions == null) {
                            exceptions = new ArrayList<Exception>();
                        }
                        exceptions.add(e2);
                    }
                }
            }
            if (!success) {
                if (this.lenient) {
                    return null;
                }
                IllegalArgumentException exception = new IllegalArgumentException("Could not find working property accessor for attribute (" + this.attPath + ") in object (" + obj + ")");
                if (exceptions != null) {
                    exceptions.forEach(e -> exception.addSuppressed(exception));
                }
                throw exception;
            }
            this.lastAccessor = accessor;
        }
        if (target == null) {
            return (T)value;
        }
        return (T)Converters.convert((Object)value, target);
    }

    public String toString() {
        return this.attPath;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            boolean isEqual;
            AttributeExpressionImpl expAttr = (AttributeExpressionImpl)obj;
            boolean bl = isEqual = Filters.getExpressionType(expAttr) == Filters.getExpressionType(this);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("expression type match:" + isEqual + "; in:" + Filters.getExpressionType(expAttr) + "; out:" + Filters.getExpressionType(this));
            }
            boolean bl2 = expAttr.attPath != null ? isEqual && expAttr.attPath.equals(this.attPath) : (isEqual = isEqual && this.attPath == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attribute match:" + isEqual + "; in:" + expAttr.getPropertyName() + "; out:" + this.attPath);
            }
            boolean bl3 = expAttr.schema != null ? isEqual && expAttr.schema.equals(this.schema) : (isEqual = isEqual && this.schema == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("schema match:" + isEqual + "; in:" + expAttr.schema + "; out:" + this.schema);
            }
            return isEqual;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.attPath == null ? 0 : this.attPath.hashCode());
        result = 37 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((PropertyName)this, extraData);
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }
}

