/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.api.data.DelegatingFeatureReader;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.type.FeatureType;

public class MaxFeatureReader<T extends FeatureType, F extends Feature>
implements DelegatingFeatureReader<T, F> {
    protected final FeatureReader<T, F> featureReader;
    protected final int maxFeatures;
    protected int counter = 0;

    public MaxFeatureReader(FeatureReader<T, F> featureReader, int maxFeatures) {
        this.featureReader = featureReader;
        this.maxFeatures = maxFeatures;
    }

    @Override
    public FeatureReader<T, F> getDelegate() {
        return this.featureReader;
    }

    @Override
    public F next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            ++this.counter;
            return this.featureReader.next();
        }
        throw new NoSuchElementException("No such Feature exists");
    }

    @Override
    public void close() throws IOException {
        this.featureReader.close();
    }

    @Override
    public T getFeatureType() {
        return this.featureReader.getFeatureType();
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.featureReader.hasNext() && this.counter < this.maxFeatures;
    }
}

