/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core.internal.provider;

import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReader;
import java.lang.module.ModuleReference;
import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.core.internal.provider.EmbeddedModulePath;

class InMemoryModuleFinder
implements ModuleFinder {
    private final Map<String, ModuleReference> namesToReference;

    static InMemoryModuleFinder of(Set<String> missingModules, Path ... entries) {
        return new InMemoryModuleFinder(Arrays.stream(entries).map(EmbeddedModulePath::descriptorFor).map(md -> InMemoryModuleFinder.filterRequires(md, missingModules)).collect(Collectors.toUnmodifiableMap(ModuleDescriptor::name, m -> new InMemoryModuleReference((ModuleDescriptor)m, URI.create("module:/" + m.name())))));
    }

    static ModuleDescriptor filterRequires(ModuleDescriptor md, Set<String> missingModules) {
        if (missingModules.size() == 0 || md.isAutomatic() || !md.requires().stream().anyMatch(req -> missingModules.contains(req.name()))) {
            return md;
        }
        ModuleDescriptor.Builder builder = md.isOpen() ? ModuleDescriptor.newOpenModule(md.name()) : ModuleDescriptor.newModule(md.name());
        md.version().ifPresent(builder::version);
        md.requires().stream().filter(req -> !missingModules.contains(req.name())).forEach(builder::requires);
        md.exports().forEach(builder::exports);
        md.opens().forEach(builder::opens);
        md.provides().forEach(builder::provides);
        md.uses().forEach(builder::uses);
        builder.packages(md.packages());
        return builder.build();
    }

    static InMemoryModuleFinder of(ModuleDescriptor ... descriptors) {
        return new InMemoryModuleFinder(Arrays.stream(descriptors).collect(Collectors.toUnmodifiableMap(ModuleDescriptor::name, m -> new InMemoryModuleReference((ModuleDescriptor)m, URI.create("module:/" + m.name())))));
    }

    private InMemoryModuleFinder(Map<String, ModuleReference> mrefs) {
        this.namesToReference = mrefs;
    }

    @Override
    public Optional<ModuleReference> find(String name) {
        Objects.requireNonNull(name);
        return Optional.ofNullable(this.namesToReference.get(name));
    }

    @Override
    public Set<ModuleReference> findAll() {
        return Set.copyOf(this.namesToReference.values());
    }

    static class InMemoryModuleReference
    extends ModuleReference {
        InMemoryModuleReference(ModuleDescriptor descriptor, URI location) {
            super(descriptor, location);
        }

        @Override
        public ModuleReader open() {
            throw new UnsupportedOperationException();
        }
    }
}

