/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.core;

import java.util.function.Predicate;

public enum RestApiVersion {
    V_8(8),
    V_7(7);

    public final byte major;
    private static final RestApiVersion CURRENT;
    private static final RestApiVersion PREVIOUS;

    private RestApiVersion(int major) {
        this.major = (byte)major;
    }

    public boolean matches(Predicate<RestApiVersion> restApiVersionFunctions) {
        return restApiVersionFunctions.test(this);
    }

    public static RestApiVersion current() {
        return CURRENT;
    }

    public static RestApiVersion previous() {
        return PREVIOUS;
    }

    public static RestApiVersion minimumSupported() {
        return PREVIOUS;
    }

    public static Predicate<RestApiVersion> equalTo(RestApiVersion restApiVersion) {
        return switch (restApiVersion) {
            default -> throw new IncompatibleClassChangeError();
            case V_8 -> r -> r.major == RestApiVersion.V_8.major;
            case V_7 -> r -> r.major == RestApiVersion.V_7.major;
        };
    }

    public static Predicate<RestApiVersion> onOrAfter(RestApiVersion restApiVersion) {
        return switch (restApiVersion) {
            default -> throw new IncompatibleClassChangeError();
            case V_8 -> r -> r.major >= RestApiVersion.V_8.major;
            case V_7 -> r -> r.major >= RestApiVersion.V_7.major;
        };
    }

    static {
        CURRENT = V_8;
        PREVIOUS = V_7;
    }
}

