/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.optimizer.reorder;

import org.apache.jena.sparql.engine.optimizer.Pattern;
import org.apache.jena.sparql.engine.optimizer.StatsMatcher;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternElements;
import org.apache.jena.sparql.engine.optimizer.reorder.PatternTriple;
import org.apache.jena.sparql.engine.optimizer.reorder.ReorderTransformationSubstitution;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.vocabulary.RDF;

public class ReorderFixed
extends ReorderTransformationSubstitution {
    private static final Item rdfType = ReorderFixed.type();
    public static final int MultiTermSampleSize = 100;
    private static final StatsMatcher matcher = new StatsMatcher();
    private static final StatsMatcher matcherRdfType = new StatsMatcher();

    private static Item type() {
        return Item.createNode(RDF.Init.type().asNode());
    }

    private static void init() {
        matcherRdfType.addPattern(new Pattern(5.0, PatternElements.VAR, rdfType, PatternElements.TERM));
        matcherRdfType.addPattern(new Pattern(50.0, PatternElements.VAR, rdfType, PatternElements.VAR));
        matcher.addPattern(new Pattern(2.0, PatternElements.TERM, PatternElements.TERM, PatternElements.VAR));
        matcher.addPattern(new Pattern(3.0, PatternElements.VAR, PatternElements.TERM, PatternElements.TERM));
        matcher.addPattern(new Pattern(2.0, PatternElements.TERM, PatternElements.VAR, PatternElements.TERM));
        matcher.addPattern(new Pattern(10.0, PatternElements.TERM, PatternElements.VAR, PatternElements.VAR));
        matcher.addPattern(new Pattern(20.0, PatternElements.VAR, PatternElements.VAR, PatternElements.TERM));
        matcher.addPattern(new Pattern(30.0, PatternElements.VAR, PatternElements.TERM, PatternElements.VAR));
        matcher.addPattern(new Pattern(100.0, PatternElements.VAR, PatternElements.VAR, PatternElements.VAR));
    }

    @Override
    public double weight(PatternTriple pt) {
        double w;
        if (rdfType.equals(pt.predicate) && (w = matcherRdfType.match(pt)) > 0.0) {
            return w;
        }
        return matcher.match(pt);
    }

    static {
        ReorderFixed.init();
    }
}

