/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.auditable.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.fao.geonet.auditable.model.RevisionFieldChange;
import org.fao.geonet.domain.ISODate;

public class RevisionInfo {
    private final int revisionNumber;
    private final String user;
    private final String date;
    private final String value;
    private final List<RevisionFieldChange> changes;

    public RevisionInfo(int revisionNumber, String user, Date date, String value) {
        this.revisionNumber = revisionNumber;
        this.user = user;
        this.date = new ISODate(date.getTime()).toString();
        this.value = value;
        this.changes = new ArrayList<RevisionFieldChange>();
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public String getUser() {
        return this.user;
    }

    public String getDate() {
        return this.date;
    }

    public String getValue() {
        return this.value;
    }

    public List<RevisionFieldChange> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void addChange(RevisionFieldChange change) {
        this.changes.add(change);
    }
}

