/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.SystemdLibrary;

class JdkSystemdLibrary
implements SystemdLibrary {
    private static final MethodHandle sd_notify$mh;

    JdkSystemdLibrary() {
    }

    static List<String> findLibSystemd() {
        final Path libsystemd = Paths.get("libsystemd.so.0", new String[0]);
        String libpath = System.getProperty("java.library.path");
        final ArrayList<String> foundPaths = new ArrayList<String>();
        Arrays.stream(libpath.split(":")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(rootPath -> {
            try {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        if (Files.isReadable(dir)) {
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.getFileName().equals(libsystemd)) {
                            foundPaths.add(file.toAbsolutePath().toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return foundPaths;
    }

    @Override
    public int sd_notify(int unset_environment, String state) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment nativeState = MemorySegmentUtil.allocateString(arena, state);
            int n = sd_notify$mh.invokeExact(unset_environment, nativeState);
            if (arena != null) {
                arena.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    static {
        List<String> paths = JdkSystemdLibrary.findLibSystemd();
        if (paths.isEmpty()) {
            String libpath = System.getProperty("java.library.path");
            throw new UnsatisfiedLinkError("Could not find libsystemd in java.library.path: " + libpath);
        }
        UnsatisfiedLinkError last = null;
        for (String path : paths) {
            try {
                System.load(path);
                last = null;
                break;
            }
            catch (UnsatisfiedLinkError e) {
                last = e;
            }
        }
        if (last != null) {
            throw last;
        }
        sd_notify$mh = LinkerHelper.downcallHandle("sd_notify", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS), new Linker.Option[0]);
    }
}

