/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.search.Query;
import org.elasticsearch.search.profile.AbstractInternalProfileTree;
import org.elasticsearch.search.profile.Timer;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;

final class InternalQueryProfileTree
extends AbstractInternalProfileTree<QueryProfileBreakdown, Query> {
    private final AtomicLong rewriteTime = new AtomicLong(0L);

    InternalQueryProfileTree() {
    }

    @Override
    protected QueryProfileBreakdown createProfileBreakdown() {
        return new QueryProfileBreakdown();
    }

    @Override
    protected String getTypeFromElement(Query query) {
        if (query.getClass().getSimpleName().isEmpty()) {
            return query.getClass().getSuperclass().getSimpleName();
        }
        return query.getClass().getSimpleName();
    }

    @Override
    protected String getDescriptionFromElement(Query query) {
        return query.toString();
    }

    public Timer startRewriteTime() {
        Timer timer = new Timer();
        timer.start();
        return timer;
    }

    public long stopAndAddRewriteTime(Timer timer) {
        timer.stop();
        assert (timer.getCount() == 1L) : "stopAndAddRewriteTime() called without a matching startRewriteTime()";
        long time = Math.max(1L, timer.getApproximateTiming());
        return this.rewriteTime.addAndGet(time);
    }

    public long getRewriteTime() {
        return this.rewriteTime.get();
    }
}

