/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.AggregatorsReducer;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;

public final class DelayedBucketReducer<B extends MultiBucketsAggregation.Bucket> {
    private final AggregationReduceContext context;
    private B proto;
    private final List<InternalAggregations> internalAggregations;
    private long count = 0L;

    public DelayedBucketReducer(B proto, AggregationReduceContext context) {
        this.proto = proto;
        this.context = context;
        this.internalAggregations = new ArrayList<InternalAggregations>();
    }

    public void accept(B bucket) {
        this.count += bucket.getDocCount();
        this.internalAggregations.add(bucket.getAggregations());
    }

    public B getProto() {
        return this.proto;
    }

    public void reset(B proto) {
        this.proto = proto;
        this.count = 0L;
        this.internalAggregations.clear();
    }

    public InternalAggregations getAggregations() {
        try (AggregatorsReducer aggregatorsReducer = new AggregatorsReducer(this.context, this.internalAggregations.size());){
            for (InternalAggregations agg : this.internalAggregations) {
                aggregatorsReducer.accept(agg);
            }
            InternalAggregations internalAggregations = aggregatorsReducer.get();
            return internalAggregations;
        }
    }

    public long getDocCount() {
        return this.count;
    }
}

