/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

public class RunOnce
implements Runnable {
    private static final VarHandle VH_DELEGATE_FIELD;
    private volatile Runnable delegate;

    public RunOnce(Runnable delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void run() {
        Runnable acquired = VH_DELEGATE_FIELD.compareAndExchange(this, this.delegate, null);
        if (acquired != null) {
            acquired.run();
        }
    }

    public boolean hasRun() {
        return this.delegate == null;
    }

    public String toString() {
        return "RunOnce[" + this.delegate + "]";
    }

    static {
        try {
            VH_DELEGATE_FIELD = MethodHandles.lookup().in(RunOnce.class).findVarHandle(RunOnce.class, "delegate", Runnable.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

