/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.ReservedStateErrorMetadata;
import org.elasticsearch.cluster.metadata.ReservedStateHandlerMetadata;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record ReservedStateMetadata(String namespace, Long version, Map<String, ReservedStateHandlerMetadata> handlers, ReservedStateErrorMetadata errorMetadata) implements SimpleDiffable<ReservedStateMetadata>,
ToXContentFragment
{
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField HANDLERS = new ParseField("handlers", new String[0]);
    private static final ParseField ERRORS_METADATA = new ParseField("errors", new String[0]);
    private static final ConstructingObjectParser<ReservedStateMetadata, String> PARSER = new ConstructingObjectParser("reserved_state_metadata", false, (a, namespace) -> {
        HashMap handlers = new HashMap();
        List handlersList = (List)a[1];
        handlersList.forEach(h -> handlers.put(h.name(), h));
        return new ReservedStateMetadata((String)namespace, (Long)a[0], Map.copyOf(handlers), (ReservedStateErrorMetadata)a[2]);
    });

    public Set<String> conflicts(String handlerName, Set<String> modified) {
        ReservedStateHandlerMetadata handlerMetadata = this.handlers.get(handlerName);
        if (handlerMetadata == null || handlerMetadata.keys().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> intersect = new HashSet<String>(handlerMetadata.keys());
        intersect.retainAll(modified);
        return Collections.unmodifiableSet(intersect);
    }

    public static ReservedStateMetadata readFrom(StreamInput in) throws IOException {
        Builder builder = new Builder(in.readString()).version(in.readLong());
        int handlersSize = in.readVInt();
        for (int i = 0; i < handlersSize; ++i) {
            ReservedStateHandlerMetadata handler = ReservedStateHandlerMetadata.readFrom(in);
            builder.putHandler(handler);
        }
        builder.errorMetadata(in.readOptionalWriteable(ReservedStateErrorMetadata::readFrom));
        return builder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.namespace);
        out.writeLong(this.version);
        out.writeCollection(this.handlers.values());
        out.writeOptionalWriteable(this.errorMetadata);
    }

    public static Diff<ReservedStateMetadata> readDiffFrom(StreamInput in) throws IOException {
        return SimpleDiffable.readDiffFrom(ReservedStateMetadata::readFrom, in);
    }

    public static Builder builder(String namespace) {
        return new Builder(namespace);
    }

    public static Builder builder(String namespace, ReservedStateMetadata metadata) {
        return new Builder(namespace, metadata);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.namespace());
        builder.field(VERSION.getPreferredName(), this.version);
        builder.startObject(HANDLERS.getPreferredName());
        Iterator i = this.handlers.entrySet().stream().sorted(Map.Entry.comparingByKey()).iterator();
        while (i.hasNext()) {
            ((ReservedStateHandlerMetadata)((Map.Entry)i.next()).getValue()).toXContent(builder, params);
        }
        builder.endObject();
        builder.field(ERRORS_METADATA.getPreferredName(), (ToXContent)this.errorMetadata);
        builder.endObject();
        return builder;
    }

    public static ReservedStateMetadata fromXContent(XContentParser parser) throws IOException {
        parser.nextToken();
        return (ReservedStateMetadata)PARSER.apply(parser, (Object)parser.currentName());
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION);
        PARSER.declareNamedObjects(ConstructingObjectParser.optionalConstructorArg(), (p, c, name) -> ReservedStateHandlerMetadata.fromXContent(p, name), HANDLERS);
        PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ReservedStateErrorMetadata.fromXContent(p), null, ERRORS_METADATA);
    }

    public static class Builder {
        private final String namespace;
        private Long version;
        private Map<String, ReservedStateHandlerMetadata> handlers;
        ReservedStateErrorMetadata errorMetadata;

        public Builder(String namespace) {
            this.namespace = namespace;
            this.version = -1L;
            this.handlers = new HashMap<String, ReservedStateHandlerMetadata>();
            this.errorMetadata = null;
        }

        public Builder(ReservedStateMetadata metadata) {
            this(metadata.namespace);
            this.version = metadata.version;
            this.handlers = new HashMap<String, ReservedStateHandlerMetadata>(metadata.handlers);
            this.errorMetadata = metadata.errorMetadata;
        }

        public Builder(String namespace, ReservedStateMetadata metadata) {
            this(namespace);
            if (metadata != null) {
                this.version = metadata.version;
                this.handlers = new HashMap<String, ReservedStateHandlerMetadata>(metadata.handlers);
                this.errorMetadata = metadata.errorMetadata;
            }
        }

        public Builder version(Long version) {
            this.version = version;
            return this;
        }

        public Builder errorMetadata(ReservedStateErrorMetadata errorMetadata) {
            this.errorMetadata = errorMetadata;
            return this;
        }

        public Builder putHandler(ReservedStateHandlerMetadata handler) {
            this.handlers.put(handler.name(), handler);
            return this;
        }

        public ReservedStateHandlerMetadata getHandler(String handlerName) {
            return this.handlers.get(handlerName);
        }

        public ReservedStateMetadata build() {
            return new ReservedStateMetadata(this.namespace, this.version, Collections.unmodifiableMap(this.handlers), this.errorMetadata);
        }
    }
}

