/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.Condition;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.OptimalShardCountCondition;
import org.elasticsearch.action.admin.indices.rollover.RolloverAction;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.datastreams.autosharding.AutoShardingResult;
import org.elasticsearch.action.datastreams.autosharding.AutoShardingType;
import org.elasticsearch.action.datastreams.autosharding.DataStreamAutoShardingService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadataStats;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.DocsStats;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRolloverAction
extends TransportMasterNodeAction<RolloverRequest, RolloverResponse> {
    private static final Logger logger = LogManager.getLogger(TransportRolloverAction.class);
    private final Client client;
    private final MasterServiceTaskQueue<RolloverTask> rolloverTaskQueue;
    private final MetadataDataStreamsService metadataDataStreamsService;
    private final DataStreamAutoShardingService dataStreamAutoShardingService;

    @Inject
    public TransportRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client, AllocationService allocationService, MetadataDataStreamsService metadataDataStreamsService, DataStreamAutoShardingService dataStreamAutoShardingService) {
        this(RolloverAction.INSTANCE, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, rolloverService, client, allocationService, metadataDataStreamsService, dataStreamAutoShardingService);
    }

    TransportRolloverAction(ActionType<RolloverResponse> actionType, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, Client client, AllocationService allocationService, MetadataDataStreamsService metadataDataStreamsService, DataStreamAutoShardingService dataStreamAutoShardingService) {
        super(actionType.name(), transportService, clusterService, threadPool, actionFilters, RolloverRequest::new, indexNameExpressionResolver, RolloverResponse::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.rolloverTaskQueue = clusterService.createTaskQueue("rollover", Priority.NORMAL, new RolloverExecutor(clusterService, allocationService, rolloverService, threadPool));
        this.metadataDataStreamsService = metadataDataStreamsService;
        this.dataStreamAutoShardingService = dataStreamAutoShardingService;
    }

    @Override
    protected ClusterBlockException checkBlock(RolloverRequest request, ClusterState state) {
        IndicesOptions indicesOptions = new IndicesOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS, IndicesOptions.WildcardOptions.builder().matchOpen(request.indicesOptions().expandWildcardsOpen()).matchClosed(request.indicesOptions().expandWildcardsClosed()).build(), IndicesOptions.GatekeeperOptions.DEFAULT, request.indicesOptions().failureStoreOptions());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, this.indexNameExpressionResolver.concreteIndexNames(state, indicesOptions, request));
    }

    @Override
    protected void masterOperation(Task task, RolloverRequest rolloverRequest, ClusterState clusterState, ActionListener<RolloverResponse> listener) throws Exception {
        IndexAbstraction rolloverTargetAbstraction;
        assert (task instanceof CancellableTask);
        Metadata metadata = clusterState.metadata();
        MetadataRolloverService.NameResolution trialRolloverNames = MetadataRolloverService.resolveRolloverNames(clusterState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), rolloverRequest.indicesOptions().failureStoreOptions().includeFailureIndices());
        String trialSourceIndexName = trialRolloverNames.sourceName();
        String trialRolloverIndexName = trialRolloverNames.rolloverName();
        MetadataRolloverService.validateIndexName(clusterState, trialRolloverIndexName);
        boolean isDataStream = metadata.dataStreams().containsKey(rolloverRequest.getRolloverTarget());
        if (rolloverRequest.isLazy()) {
            if (!isDataStream || rolloverRequest.getConditions().hasConditions()) {
                String message = isDataStream ? "Lazy rollover can be used only without any conditions. Please remove the conditions from the request body or the query parameter 'lazy'." : (!rolloverRequest.getConditions().hasConditions() ? "Lazy rollover can be applied only on a data stream. Please remove the query parameter 'lazy'." : "Lazy rollover can be applied only on a data stream with no conditions. Please remove the query parameter 'lazy'.");
                listener.onFailure(new IllegalArgumentException(message));
                return;
            }
            if (!rolloverRequest.isDryRun()) {
                this.metadataDataStreamsService.setRolloverOnWrite(rolloverRequest.getRolloverTarget(), true, rolloverRequest.ackTimeout(), rolloverRequest.masterNodeTimeout(), listener.map(response -> new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, Map.of(), false, false, response.isAcknowledged(), false, response.isAcknowledged())));
                return;
            }
        }
        if ((rolloverTargetAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(rolloverRequest.getRolloverTarget())).getType() == IndexAbstraction.Type.ALIAS && rolloverTargetAbstraction.isDataStreamRelated()) {
            listener.onFailure(new IllegalStateException("Aliases to data streams cannot be rolled over. Please rollover the data stream itself."));
            return;
        }
        IndicesOptions statsIndicesOptions = new IndicesOptions(IndicesOptions.ConcreteTargetOptions.ALLOW_UNAVAILABLE_TARGETS, IndicesOptions.WildcardOptions.builder().matchClosed(true).allowEmptyExpressions(false).build(), IndicesOptions.GatekeeperOptions.DEFAULT, rolloverRequest.indicesOptions().failureStoreOptions());
        IndicesStatsRequest statsRequest = ((IndicesStatsRequest)((IndicesStatsRequest)new IndicesStatsRequest().indices(new String[]{rolloverRequest.getRolloverTarget()})).clear().indicesOptions(statsIndicesOptions)).docs(true).indexing(true);
        statsRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.client.execute(IndicesStatsAction.INSTANCE, statsRequest, listener.delegateFailureAndWrap((delegate, statsResponse) -> {
            AutoShardingResult rolloverAutoSharding = null;
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(rolloverRequest.getRolloverTarget());
            if (indexAbstraction.getType().equals((Object)IndexAbstraction.Type.DATA_STREAM)) {
                DataStream dataStream = (DataStream)indexAbstraction;
                Optional<IndexStats> indexStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(dataStream.getWriteIndex().getName()));
                Double indexWriteLoad = indexStats.map(stats -> Arrays.stream(stats.getShards()).filter(shardStats -> shardStats.getStats().indexing != null).filter(shardStats -> shardStats.getShardRouting().primary()).map(shardStats -> shardStats.getStats().indexing.getTotal().getWriteLoad()).reduce(0.0, Double::sum)).orElse(null);
                rolloverAutoSharding = this.dataStreamAutoShardingService.calculate(clusterState, dataStream, indexWriteLoad);
                logger.debug("auto sharding result for data stream [{}] is [{}]", (Object)dataStream.getName(), (Object)rolloverAutoSharding);
                if (rolloverAutoSharding.type().equals((Object)AutoShardingType.INCREASE_SHARDS)) {
                    RolloverConditions conditionsIncludingImplicit = RolloverConditions.newBuilder(rolloverRequest.getConditions()).addOptimalShardCountCondition(rolloverAutoSharding).build();
                    rolloverRequest.setConditions(conditionsIncludingImplicit);
                }
            }
            Map<String, Boolean> trialConditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditionValues(), TransportRolloverAction.buildStats(metadata.index(trialSourceIndexName), statsResponse));
            RolloverResponse trialRolloverResponse = new RolloverResponse(trialSourceIndexName, trialRolloverIndexName, trialConditionResults, rolloverRequest.isDryRun(), false, false, false, rolloverRequest.isLazy());
            if (rolloverRequest.isDryRun()) {
                delegate.onResponse(trialRolloverResponse);
                return;
            }
            if (rolloverRequest.areConditionsMet(trialConditionResults)) {
                String source = "rollover_index source [" + trialRolloverIndexName + "] to target [" + trialRolloverIndexName + "]";
                RolloverTask rolloverTask = new RolloverTask(rolloverRequest, (IndicesStatsResponse)statsResponse, trialRolloverResponse, rolloverAutoSharding, (ActionListener<RolloverResponse>)delegate);
                this.submitRolloverTask(rolloverRequest, source, rolloverTask);
            } else {
                delegate.onResponse(trialRolloverResponse);
            }
        }));
    }

    void submitRolloverTask(RolloverRequest rolloverRequest, String source, RolloverTask rolloverTask) {
        this.rolloverTaskQueue.submitTask(source, rolloverTask, rolloverRequest.masterNodeTimeout());
    }

    static Map<String, Boolean> evaluateConditions(Collection<Condition<?>> conditions, @Nullable Condition.Stats stats) {
        Objects.requireNonNull(conditions, "conditions must not be null");
        if (stats != null) {
            return conditions.stream().map(condition -> condition.evaluate(stats)).collect(Collectors.toMap(result -> result.condition().toString(), Condition.Result::matched));
        }
        return conditions.stream().collect(Collectors.toMap(Condition::toString, cond -> false));
    }

    static Condition.Stats buildStats(@Nullable IndexMetadata metadata, @Nullable IndicesStatsResponse statsResponse) {
        if (metadata == null) {
            return null;
        }
        Optional<IndexStats> indexStats = Optional.ofNullable(statsResponse).map(stats -> stats.getIndex(metadata.getIndex().getName()));
        DocsStats docsStats = indexStats.map(stats -> stats.getPrimaries().getDocs()).orElse(null);
        long maxPrimaryShardSize = indexStats.stream().map(IndexStats::getShards).filter(Objects::nonNull).flatMap(Arrays::stream).filter(shard -> shard.getShardRouting().primary()).map(ShardStats::getStats).mapToLong(shard -> shard.docs == null ? 0L : shard.docs.getTotalSizeInBytes()).max().orElse(0L);
        long maxPrimaryShardDocs = indexStats.stream().map(IndexStats::getShards).filter(Objects::nonNull).flatMap(Arrays::stream).filter(shard -> shard.getShardRouting().primary()).map(ShardStats::getStats).mapToLong(shard -> shard.docs == null ? 0L : shard.docs.getCount()).max().orElse(0L);
        return new Condition.Stats(docsStats == null ? 0L : docsStats.getCount(), metadata.getCreationDate(), ByteSizeValue.ofBytes(docsStats == null ? 0L : docsStats.getTotalSizeInBytes()), ByteSizeValue.ofBytes(maxPrimaryShardSize), maxPrimaryShardDocs);
    }

    record RolloverExecutor(ClusterService clusterService, AllocationService allocationService, MetadataRolloverService rolloverService, ThreadPool threadPool) implements ClusterStateTaskExecutor<RolloverTask>
    {
        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<RolloverTask> batchExecutionContext) {
            AllocationActionMultiListener<RolloverResponse> listener = new AllocationActionMultiListener<RolloverResponse>(this.threadPool.getThreadContext());
            ArrayList<MetadataRolloverService.RolloverResult> results = new ArrayList<MetadataRolloverService.RolloverResult>(batchExecutionContext.taskContexts().size());
            ClusterState state = batchExecutionContext.initialState();
            for (ClusterStateTaskExecutor.TaskContext<RolloverTask> taskContext : batchExecutionContext.taskContexts()) {
                try {
                    Releasable ignored = taskContext.captureResponseHeaders();
                    try {
                        state = this.executeTask(state, results, taskContext, listener);
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                    }
                }
                catch (Exception e) {
                    taskContext.onFailure(e);
                }
            }
            if (state != batchExecutionContext.initialState()) {
                StringBuilder reason = new StringBuilder();
                Strings.collectionToDelimitedStringWithLimit(() -> Iterators.map(results.iterator(), t -> t.sourceIndexName() + "->" + t.rolloverIndexName()), ",", "bulk rollover [", "]", 1024, reason);
                try (Releasable ignored = batchExecutionContext.dropHeadersContext();){
                    state = this.allocationService.reroute(state, reason.toString(), listener.reroute());
                }
            } else {
                listener.noRerouteNeeded();
            }
            return state;
        }

        public ClusterState executeTask(ClusterState currentState, List<MetadataRolloverService.RolloverResult> results, ClusterStateTaskExecutor.TaskContext<RolloverTask> rolloverTaskContext, AllocationActionMultiListener<RolloverResponse> allocationActionMultiListener) throws Exception {
            RolloverTask rolloverTask = rolloverTaskContext.getTask();
            RolloverRequest rolloverRequest = rolloverTask.rolloverRequest();
            MetadataRolloverService.NameResolution rolloverNames = MetadataRolloverService.resolveRolloverNames(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), rolloverRequest.targetsFailureStore());
            IndexMetadata rolloverSourceIndex = currentState.metadata().index(rolloverNames.sourceName());
            Map<String, Boolean> postConditionResults = TransportRolloverAction.evaluateConditions(rolloverRequest.getConditionValues(), TransportRolloverAction.buildStats(rolloverSourceIndex, rolloverTask.statsResponse()));
            if (rolloverRequest.getConditions().areConditionsMet(postConditionResults)) {
                HashMap<String, Boolean> resultsIncludingDecreaseShards = new HashMap<String, Boolean>(postConditionResults);
                if (rolloverTask.autoShardingResult != null && rolloverTask.autoShardingResult.type().equals((Object)AutoShardingType.DECREASE_SHARDS)) {
                    RolloverConditions conditionsIncludingDecreaseShards = RolloverConditions.newBuilder(rolloverRequest.getConditions()).addOptimalShardCountCondition(rolloverTask.autoShardingResult).build();
                    rolloverRequest.setConditions(conditionsIncludingDecreaseShards);
                    resultsIncludingDecreaseShards.put(new OptimalShardCountCondition(rolloverTask.autoShardingResult.targetNumberOfShards()).toString(), true);
                }
                List<Condition<?>> metConditions = rolloverRequest.getConditionValues().stream().filter(condition -> (Boolean)resultsIncludingDecreaseShards.get(condition.toString())).toList();
                IndexAbstraction rolloverTargetAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(rolloverRequest.getRolloverTarget());
                IndexMetadataStats sourceIndexStats = rolloverTargetAbstraction.getType() == IndexAbstraction.Type.DATA_STREAM ? IndexMetadataStats.fromStatsResponse(rolloverSourceIndex, rolloverTask.statsResponse()) : null;
                MetadataRolloverService.RolloverResult rolloverResult = this.rolloverService.rolloverClusterState(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), metConditions, Instant.now(), false, false, sourceIndexStats, rolloverTask.autoShardingResult(), rolloverRequest.targetsFailureStore());
                results.add(rolloverResult);
                logger.trace("rollover result [{}]", (Object)rolloverResult);
                String rolloverIndexName = rolloverResult.rolloverIndexName();
                String sourceIndexName = rolloverResult.sourceIndexName();
                TimeValue waitForActiveShardsTimeout = rolloverRequest.masterNodeTimeout().millis() < 0L ? null : rolloverRequest.masterNodeTimeout();
                rolloverTaskContext.success(() -> ActiveShardsObserver.waitForActiveShards(this.clusterService, new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), waitForActiveShardsTimeout, allocationActionMultiListener.delay(rolloverTask.listener()).map(isShardsAcknowledged -> new RolloverResponse(sourceIndexName, rolloverIndexName, resultsIncludingDecreaseShards, false, true, true, (boolean)isShardsAcknowledged, false))));
                return rolloverResult.clusterState();
            }
            rolloverTaskContext.success(() -> rolloverTask.listener().onResponse(rolloverTask.trialRolloverResponse()));
            return currentState;
        }
    }

    record RolloverTask(RolloverRequest rolloverRequest, IndicesStatsResponse statsResponse, RolloverResponse trialRolloverResponse, @Nullable AutoShardingResult autoShardingResult, ActionListener<RolloverResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }
}

