/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.styling;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.ExpressionDOMParser;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SLDInlineFeatureParser {
    private static Map<Integer, CoordinateReferenceSystem> SRSLookup = new HashMap<Integer, CoordinateReferenceSystem>();
    public SimpleFeatureType featureType = null;
    public DataStore dataStore = null;
    Node rootNode = null;
    ArrayList<Feature> features = new ArrayList();
    CoordinateReferenceSystem SRS = null;
    private static int uniqueNumber = 0;

    public SLDInlineFeatureParser(Node root) throws Exception {
        boolean isFeatureCollection = false;
        if (!this.isSimple(root)) {
            throw new Exception("couldnt parse the SLD Inline features!");
        }
        Node fc = this.getNode(root, "FeatureCollection");
        if (fc != null) {
            isFeatureCollection = true;
            root = fc;
        }
        this.featureType = this.makeFeatureType(root, isFeatureCollection);
        if (this.featureType == null) {
            throw new Exception("SLD InlineFeature Parser - couldnt determine a FeatureType.  See help for whats supported.");
        }
        this.makeFeatures(root, isFeatureCollection);
        if (this.features.isEmpty()) {
            throw new Exception("SLD InlineFeature Parser - didnt find any features!");
        }
        this.buildStore();
    }

    private void makeFeatures(Node root, boolean isCollection) throws Exception {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            if (isCollection) {
                child = this.descend(child);
            }
            if (child == null) {
                throw new Exception("SLD inlineFeature Parser - couldnt extract a feature from the dom.");
            }
            SimpleFeature f = this.parseFeature(child, this.featureType);
            this.features.add((Feature)f);
        }
    }

    private Node descend(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            return child;
        }
        return null;
    }

    private SimpleFeature parseFeature(Node feature, SimpleFeatureType featureType) throws Exception {
        Object[] nullAtts = new Object[featureType.getAttributeCount()];
        SimpleFeature f = SimpleFeatureBuilder.build(featureType, nullAtts, null);
        NodeList children = feature.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            Object value = this.getValue(child);
            try {
                f.setAttribute(childName, value);
                continue;
            }
            catch (Exception e) {
                Logger.getGlobal().log(Level.INFO, "", e);
            }
        }
        return f;
    }

    private Object getValue(Node root) throws Exception {
        NodeList children = root.getChildNodes();
        StringBuffer strVal = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null) continue;
            if (child.getNodeType() == 3) {
                strVal.append(child.getNodeValue());
            }
            if (child.getNodeType() != 1) continue;
            return this.parseGeometry(child);
        }
        return strVal;
    }

    private Geometry parseGeometry(Node root) throws Exception {
        Node srsName;
        NamedNodeMap atts = root.getAttributes();
        if (this.SRS == null && (srsName = atts.getNamedItem("srsName")) != null) {
            this.parseSRS(srsName.getNodeValue());
        }
        ExpressionDOMParser parser = new ExpressionDOMParser(CommonFactoryFinder.getFilterFactory(null));
        return parser.gml(root);
    }

    private boolean isSimple(Node root) throws Exception {
        String childName;
        Node child;
        int i;
        int foundFeature = 0;
        int foundFC = 0;
        Node fcNode = null;
        String featureName = null;
        NodeList children = root.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("FeatureCollection")) {
                ++foundFC;
                fcNode = child;
                continue;
            }
            if (featureName == null) {
                featureName = childName;
            }
            if (childName.equalsIgnoreCase(featureName)) continue;
            throw new Exception("SLD inline feature parser  - it appear that there is >1 feature type present.  I got a " + childName + " when I was expecting a " + featureName + " tag");
        }
        if (foundFC > 1) {
            throw new Exception("SLD - UserLayer, inline feature parser - found >1 FeatureCollection.  Not supported");
        }
        if (foundFC > 0 && foundFeature > 0) {
            throw new Exception("SLD - UserLayer, inline feature parser - found  SimpleFeatureCollection and featureMembers.  Not supported");
        }
        if (foundFC == 0) {
            return true;
        }
        featureName = null;
        children = fcNode.getChildNodes();
        for (i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("featureMember")) {
                ++foundFeature;
                continue;
            }
            if (childName.equalsIgnoreCase("FeatureCollection")) {
                throw new Exception("SLD - UserLayer, inline feature parser - found a node of type FeatureCollection.  Expected a featureMember - dont support nested collections.");
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            throw new Exception("SLD - UserLayer, inline feature parser - found a node of type '" + child.getLocalName() + "' and dont understand it.  Expected a featureMember.");
        }
        return true;
    }

    private void buildStore() {
        SimpleFeatureCollection collection = DataUtilities.collection(this.features.toArray(new SimpleFeature[this.features.size()]));
        this.dataStore = DataUtilities.dataStore(collection);
    }

    private SimpleFeatureType makeFeatureType(Node root, boolean isCollection) throws Exception {
        Node feature = null;
        Node featureMember = root;
        if (isCollection) {
            featureMember = this.getNode(root, "featureMember");
        }
        NodeList children = featureMember.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (childName.equalsIgnoreCase("boundedBy")) continue;
            feature = child;
            break;
        }
        if (feature == null) {
            throw new Exception("couldnt find a Feature in the Inline Features!");
        }
        String featureName = feature.getLocalName();
        if (featureName == null) {
            featureName = feature.getNodeName();
        }
        SimpleFeatureTypeBuilder build = new SimpleFeatureTypeBuilder();
        build.setName(featureName);
        build.setNamespaceURI(new URI("http://temp.inline.feature.sld.com"));
        children = feature.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (this.isGeometry(child)) {
                this.getValue(child);
                build.add(childName, Geometry.class, this.SRS);
                continue;
            }
            build.add(childName, String.class);
        }
        return build.buildFeatureType();
    }

    private boolean isGeometry(Node root) {
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    public Node getNode(Node parentNode, String wantedChildName) {
        NodeList children = parentNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child == null || child.getNodeType() != 1) continue;
            String childName = child.getLocalName();
            if (childName == null) {
                childName = child.getNodeName();
            }
            if (!childName.equalsIgnoreCase(wantedChildName)) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUID() {
        Class<SLDInlineFeatureParser> clazz = SLDInlineFeatureParser.class;
        synchronized (SLDInlineFeatureParser.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return uniqueNumber++;
        }
    }

    private void parseSRS(String srs) throws Exception {
        if (srs == null) {
            return;
        }
        String epsgCode = srs.substring(srs.indexOf(35) + 1);
        int srsnum = Integer.parseInt(epsgCode);
        this.SRS = this.getSRS(srsnum);
    }

    private CoordinateReferenceSystem getSRS(int epsg) throws Exception {
        CoordinateReferenceSystem result = SRSLookup.get(epsg);
        if (result == null) {
            result = CRS.decode("EPSG:" + epsg);
            SRSLookup.put(epsg, result);
        }
        return result;
    }
}

